/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.web.descriptors;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.atlassian.plugin.hostcontainer.HostContainer;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.web.descriptors.WebPanelModuleDescriptor;
import com.atlassian.plugin.web.model.EmbeddedTemplateWebPanel;
import com.atlassian.plugin.web.model.ResourceTemplateWebPanel;
import com.atlassian.plugin.web.model.WebPanel;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WebPanelSupplierFactory {
    private final WebPanelModuleDescriptor webPanelModuleDescriptor;
    private final HostContainer hostContainer;
    private final ModuleFactory moduleFactory;

    public WebPanelSupplierFactory(WebPanelModuleDescriptor webPanelModuleDescriptor, HostContainer hostContainer, ModuleFactory moduleFactory) {
        this.webPanelModuleDescriptor = webPanelModuleDescriptor;
        this.hostContainer = hostContainer;
        this.moduleFactory = moduleFactory;
    }

    public Supplier<WebPanel> build(final String moduleClassName) {
        if (moduleClassName != null) {
            return new Supplier<WebPanel>(){

                public WebPanel get() {
                    return (WebPanel)WebPanelSupplierFactory.this.moduleFactory.createModule(moduleClassName, (ModuleDescriptor)WebPanelSupplierFactory.this.webPanelModuleDescriptor);
                }
            };
        }
        final ResourceDescriptor resource = this.getRequiredViewResource();
        final String filename = resource.getLocation();
        if (StringUtils.isNotEmpty((String)filename)) {
            return new Supplier<WebPanel>(){

                public WebPanel get() {
                    ResourceTemplateWebPanel panel = (ResourceTemplateWebPanel)WebPanelSupplierFactory.this.hostContainer.create(ResourceTemplateWebPanel.class);
                    panel.setResourceFilename(filename);
                    panel.setResourceType(WebPanelSupplierFactory.this.getRequiredResourceType(resource));
                    panel.setPlugin(WebPanelSupplierFactory.this.webPanelModuleDescriptor.getPlugin());
                    return panel;
                }
            };
        }
        final String body = (String)Preconditions.checkNotNull((Object)resource.getContent());
        return new Supplier<WebPanel>(){

            public WebPanel get() {
                EmbeddedTemplateWebPanel panel = (EmbeddedTemplateWebPanel)WebPanelSupplierFactory.this.hostContainer.create(EmbeddedTemplateWebPanel.class);
                panel.setTemplateBody(body);
                panel.setResourceType(WebPanelSupplierFactory.this.getRequiredResourceType(resource));
                panel.setPlugin(WebPanelSupplierFactory.this.webPanelModuleDescriptor.getPlugin());
                return panel;
            }
        };
    }

    private ResourceDescriptor getRequiredViewResource() throws PluginParseException {
        Iterable resources = Iterables.filter((Iterable)this.webPanelModuleDescriptor.getResourceDescriptors(), (Predicate)new Predicate<ResourceDescriptor>(){

            public boolean apply(ResourceDescriptor input) {
                return "view".equals(input.getName());
            }
        });
        Iterator iterator = resources.iterator();
        if (!iterator.hasNext()) {
            throw new PluginParseException("Required resource with name 'view' does not exist.");
        }
        return (ResourceDescriptor)iterator.next();
    }

    private String getRequiredResourceType(ResourceDescriptor resource) {
        String type = resource.getType();
        if (StringUtils.isEmpty((String)type)) {
            throw new PluginParseException("Resource element is lacking a type attribute.");
        }
        return type;
    }
}

