/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.atlassian.plugin.elements.ResourceLocation;
import com.atlassian.plugin.servlet.DownloadableClasspathResource;
import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.servlet.DownloadableWebResource;
import com.atlassian.plugin.servlet.ForwardableResource;
import com.atlassian.plugin.servlet.ServletContextFactory;
import com.atlassian.plugin.webresource.BatchPluginResource;
import com.atlassian.plugin.webresource.PluginResource;
import com.atlassian.plugin.webresource.PluginResourceLocator;
import com.atlassian.plugin.webresource.SinglePluginResource;
import com.atlassian.plugin.webresource.WebResourceModuleDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginResourceLocatorImpl
implements PluginResourceLocator {
    private static final Log log = LogFactory.getLog(PluginResourceLocatorImpl.class);
    public static final String PLUGIN_WEBRESOURCE_BATCHING_OFF = "plugin.webresource.batching.off";
    private static final String DOWNLOAD_TYPE = "download";
    private static String[] BATCH_PARAMS = new String[]{"ieonly", "media", "content-type", "cache"};
    private final PluginAccessor pluginAccessor;
    private final ServletContextFactory servletContextFactory;
    private static final String RESOURCE_SOURCE_PARAM = "source";
    private static final String RESOURCE_BATCH_PARAM = "batch";

    public PluginResourceLocatorImpl(PluginAccessor pluginAccessor, ServletContextFactory servletContextFactory) {
        this.pluginAccessor = pluginAccessor;
        this.servletContextFactory = servletContextFactory;
    }

    @Override
    public boolean matches(String url) {
        return SinglePluginResource.matches(url) || BatchPluginResource.matches(url);
    }

    @Override
    public DownloadableResource getDownloadableResource(String url, Map<String, String> queryParams) {
        if (BatchPluginResource.matches(url)) {
            BatchPluginResource batchResource = BatchPluginResource.parse(url, queryParams);
            return this.locateBatchPluginResource(batchResource);
        }
        if (SinglePluginResource.matches(url)) {
            SinglePluginResource resource = SinglePluginResource.parse(url);
            return this.locatePluginResource(resource.getModuleCompleteKey(), resource.getResourceName());
        }
        log.error((Object)("Cannot locate resource for unknown url: " + url));
        return null;
    }

    private DownloadableResource locateBatchPluginResource(BatchPluginResource batchResource) {
        DownloadableResource resource;
        ModuleDescriptor moduleDescriptor = this.pluginAccessor.getEnabledPluginModule(batchResource.getModuleCompleteKey());
        for (ResourceDescriptor resourceDescriptor : moduleDescriptor.getResourceDescriptors(DOWNLOAD_TYPE)) {
            if (!this.isResourceInBatch(resourceDescriptor, batchResource)) continue;
            batchResource.add(this.locatePluginResource(moduleDescriptor.getCompleteKey(), resourceDescriptor.getName()));
        }
        if (batchResource.isEmpty() && (resource = this.locatePluginResource(batchResource.getModuleCompleteKey(), batchResource.getResourceName())) != null) {
            return resource;
        }
        return batchResource;
    }

    private boolean isResourceInBatch(ResourceDescriptor resourceDescriptor, BatchPluginResource batchResource) {
        if (!resourceDescriptor.getName().endsWith("." + batchResource.getType())) {
            return false;
        }
        if (this.skipBatch(resourceDescriptor)) {
            return false;
        }
        for (String param : BATCH_PARAMS) {
            String batchValue = batchResource.getParams().get(param);
            String resourceValue = resourceDescriptor.getParameter(param);
            if (batchValue == null && resourceValue != null) {
                return false;
            }
            if (batchValue == null || batchValue.equals(resourceValue)) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private DownloadableResource locatePluginResource(String moduleCompleteKey, String resourceName) {
        DownloadableResource resource;
        block5: {
            if (moduleCompleteKey.indexOf(":") > -1) {
                ModuleDescriptor moduleDescriptor = this.pluginAccessor.getPluginModule(moduleCompleteKey);
                if (moduleDescriptor != null && this.pluginAccessor.isPluginModuleEnabled(moduleCompleteKey)) {
                    resource = this.getResourceFromModule(moduleDescriptor, resourceName, "");
                    break block5;
                } else {
                    log.info((Object)("Module not found: " + moduleCompleteKey));
                    return null;
                }
            }
            Plugin plugin = this.pluginAccessor.getPlugin(moduleCompleteKey);
            resource = this.getResourceFromPlugin(plugin, resourceName, "");
        }
        if (resource == null) {
            resource = this.getResourceFromPlugin(this.getPlugin(moduleCompleteKey), resourceName, "");
        }
        if (resource == null) {
            log.info((Object)("Unable to find resource for plugin: " + moduleCompleteKey + " and path: " + resourceName));
            return null;
        }
        return resource;
    }

    private Plugin getPlugin(String moduleKey) {
        if (moduleKey.indexOf(58) < 0 || moduleKey.indexOf(58) == moduleKey.length() - 1) {
            return null;
        }
        return this.pluginAccessor.getPlugin(moduleKey.substring(0, moduleKey.indexOf(58)));
    }

    private DownloadableResource getResourceFromModule(ModuleDescriptor moduleDescriptor, String resourcePath, String filePath) {
        Plugin plugin = this.pluginAccessor.getPlugin(moduleDescriptor.getPluginKey());
        ResourceLocation resourceLocation = moduleDescriptor.getResourceLocation(DOWNLOAD_TYPE, resourcePath);
        if (resourceLocation != null) {
            return this.getDownloadablePluginResource(plugin, resourceLocation, filePath);
        }
        String[] nextParts = this.splitLastPathPart(resourcePath);
        if (nextParts == null) {
            return null;
        }
        return this.getResourceFromModule(moduleDescriptor, nextParts[0], nextParts[1] + filePath);
    }

    private DownloadableResource getResourceFromPlugin(Plugin plugin, String resourcePath, String filePath) {
        if (plugin == null) {
            return null;
        }
        ResourceLocation resourceLocation = plugin.getResourceLocation(DOWNLOAD_TYPE, resourcePath);
        if (resourceLocation != null) {
            return this.getDownloadablePluginResource(plugin, resourceLocation, filePath);
        }
        String[] nextParts = this.splitLastPathPart(resourcePath);
        if (nextParts == null) {
            return null;
        }
        return this.getResourceFromPlugin(plugin, nextParts[0], nextParts[1] + filePath);
    }

    String[] splitLastPathPart(String resourcePath) {
        int indexOfSlash = resourcePath.lastIndexOf(47);
        if (resourcePath.endsWith("/")) {
            indexOfSlash = resourcePath.lastIndexOf(47, indexOfSlash - 1);
        }
        if (indexOfSlash < 0) {
            return null;
        }
        return new String[]{resourcePath.substring(0, indexOfSlash + 1), resourcePath.substring(indexOfSlash + 1)};
    }

    private DownloadableResource getDownloadablePluginResource(Plugin plugin, ResourceLocation resourceLocation, String filePath) {
        String sourceParam = resourceLocation.getParameter(RESOURCE_SOURCE_PARAM);
        if ("webContext".equalsIgnoreCase(sourceParam)) {
            return new ForwardableResource(resourceLocation);
        }
        if ("webContextStatic".equalsIgnoreCase(sourceParam)) {
            return new DownloadableWebResource(plugin, resourceLocation, filePath, this.servletContextFactory.getServletContext());
        }
        return new DownloadableClasspathResource(plugin, resourceLocation, filePath);
    }

    @Override
    public List<PluginResource> getPluginResources(String moduleCompleteKey) {
        ModuleDescriptor moduleDescriptor = this.pluginAccessor.getEnabledPluginModule(moduleCompleteKey);
        if (moduleDescriptor == null || !(moduleDescriptor instanceof WebResourceModuleDescriptor)) {
            log.error((Object)("Error loading resource \"" + moduleCompleteKey + "\". Resource is not a Web Resource Module"));
            return Collections.EMPTY_LIST;
        }
        boolean singleMode = Boolean.valueOf(System.getProperty(PLUGIN_WEBRESOURCE_BATCHING_OFF));
        ArrayList<PluginResource> resources = new ArrayList<PluginResource>();
        for (ResourceDescriptor resourceDescriptor : moduleDescriptor.getResourceDescriptors()) {
            if (singleMode || this.skipBatch(resourceDescriptor)) {
                boolean cache = !"false".equalsIgnoreCase(resourceDescriptor.getParameter("cache"));
                resources.add(new SinglePluginResource(resourceDescriptor.getName(), moduleDescriptor.getCompleteKey(), cache, resourceDescriptor.getParameters()));
                continue;
            }
            BatchPluginResource batchResource = this.createBatchResource(moduleDescriptor.getCompleteKey(), resourceDescriptor);
            if (resources.contains(batchResource)) continue;
            resources.add(batchResource);
        }
        return resources;
    }

    private boolean skipBatch(ResourceDescriptor resourceDescriptor) {
        return "false".equalsIgnoreCase(resourceDescriptor.getParameter(RESOURCE_BATCH_PARAM)) || "webContext".equalsIgnoreCase(resourceDescriptor.getParameter(RESOURCE_SOURCE_PARAM));
    }

    private BatchPluginResource createBatchResource(String moduleCompleteKey, ResourceDescriptor resourceDescriptor) {
        String name = resourceDescriptor.getName();
        String type = name.substring(name.lastIndexOf(".") + 1);
        TreeMap<String, String> params = new TreeMap<String, String>();
        for (String param : BATCH_PARAMS) {
            String value = resourceDescriptor.getParameter(param);
            if (!StringUtils.isNotEmpty((String)value)) continue;
            params.put(param, value);
        }
        return new BatchPluginResource(moduleCompleteKey, type, params);
    }

    @Override
    public String getResourceUrl(String moduleCompleteKey, String resourceName) {
        SinglePluginResource pluginResource = new SinglePluginResource(resourceName, moduleCompleteKey, false);
        return pluginResource.getUrl();
    }
}

