/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.url;

import com.atlassian.plugin.webresource.WebResourceModuleDescriptor;
import com.atlassian.plugin.webresource.transformer.StaticTransformers;
import com.atlassian.plugin.webresource.transformer.TransformerCache;
import com.atlassian.plugin.webresource.url.DefaultUrlBuilder;
import com.atlassian.plugin.webresource.url.UrlParameters;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Map;

public class DefaultUrlBuilderMap {
    private final Iterable<WebResourceModuleDescriptor> wrmds;
    private final StaticTransformers staticTransformers;
    private final Map<String, UrlParameters> urlBuildersByType;
    private final TransformerCache transformerCache;

    public DefaultUrlBuilderMap(WebResourceModuleDescriptor wrmd, TransformerCache transformerCache, StaticTransformers staticTransformers) {
        this.staticTransformers = staticTransformers;
        this.wrmds = ImmutableList.of((Object)((Object)wrmd));
        this.transformerCache = transformerCache;
        this.urlBuildersByType = Maps.newHashMap();
    }

    public DefaultUrlBuilderMap(Iterable<WebResourceModuleDescriptor> wrmds, TransformerCache transformerCache, StaticTransformers staticTransformers) {
        this.staticTransformers = staticTransformers;
        this.wrmds = Lists.newArrayList(wrmds);
        this.transformerCache = transformerCache;
        this.urlBuildersByType = Maps.newHashMap();
    }

    public UrlParameters getOrCreateForType(String type) {
        UrlParameters urlParams = this.urlBuildersByType.get(type);
        if (null == urlParams) {
            DefaultUrlBuilder urlBuilder = new DefaultUrlBuilder();
            for (WebResourceModuleDescriptor wrmd : this.wrmds) {
                wrmd.addToUrl(type, this.staticTransformers, this.transformerCache, urlBuilder);
            }
            urlParams = urlBuilder.build();
            this.urlBuildersByType.put(type, urlParams);
        }
        return urlParams;
    }
}

