/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.api.features;

import com.atlassian.sal.api.features.FeatureKeyClassifier;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class EnabledDarkFeatures {
    public static final EnabledDarkFeatures NONE = new EnabledDarkFeatures(Collections.<String, FeatureKeyClassifier>emptyMap());
    private final ImmutableMap<String, FeatureKeyClassifier> enabledFeatures;

    public EnabledDarkFeatures(Map<String, FeatureKeyClassifier> enabledFeatures) {
        this.enabledFeatures = ImmutableMap.copyOf(enabledFeatures);
    }

    public static EnabledDarkFeatures createFromSet(@Nullable Set<String> systemEnabledFeatures, @Nullable Set<String> siteEnabledFeatures) {
        return EnabledDarkFeatures.createFromSet(systemEnabledFeatures, siteEnabledFeatures, Collections.<String>emptySet());
    }

    public static EnabledDarkFeatures createFromSet(@Nullable Set<String> systemEnabledFeatures, @Nullable Set<String> siteEnabledFeatures, @Nullable Set<String> userEnabledFeatures) {
        ImmutableMap enabledFeatures = ImmutableMap.builder().putAll(EnabledDarkFeatures.toMap(systemEnabledFeatures, FeatureKeyClassifier.ALL_USERS_READ_ONLY)).putAll(EnabledDarkFeatures.toMap(siteEnabledFeatures, FeatureKeyClassifier.ALL_USERS)).putAll(EnabledDarkFeatures.toMap(userEnabledFeatures, FeatureKeyClassifier.CURRENT_USER_ONLY)).build();
        return new EnabledDarkFeatures((Map<String, FeatureKeyClassifier>)enabledFeatures);
    }

    private static Map<? extends String, ? extends FeatureKeyClassifier> toMap(@Nullable Set<String> enabledFeatures, FeatureKeyClassifier classifier) {
        if (enabledFeatures == null) {
            return Collections.emptyMap();
        }
        ConcurrentHashMap<String, FeatureKeyClassifier> map = new ConcurrentHashMap<String, FeatureKeyClassifier>();
        for (String featureKey : enabledFeatures) {
            map.put(featureKey, classifier);
        }
        return map;
    }

    public ImmutableSet<String> getFeatureKeys() {
        return ImmutableSet.copyOf((Collection)this.enabledFeatures.keySet());
    }

    public ImmutableSet<String> getFeatureKeys(final Predicate<FeatureKeyClassifier> criteria) {
        Preconditions.checkNotNull(criteria, (Object)"criteria");
        return ImmutableSet.copyOf(Maps.filterEntries(this.enabledFeatures, (Predicate)new Predicate<Map.Entry<String, FeatureKeyClassifier>>(){

            public boolean apply(@Nullable Map.Entry<String, FeatureKeyClassifier> input) {
                return input != null && criteria.apply((Object)input.getValue());
            }
        }).keySet());
    }

    public boolean isFeatureEnabled(String featureKey) {
        return this.enabledFeatures.containsKey((Object)featureKey);
    }

    public String toString() {
        return "EnabledDarkFeatures{enabledFeatures=" + this.enabledFeatures + '}';
    }
}

