package com.atlassian.sal.core.executor;

import com.atlassian.sal.api.executor.ThreadLocalContextManager;

import java.util.concurrent.Executor;

import static com.google.common.base.Preconditions.*;

/**
 * Executor that wraps executing runnables in a wrapper that transfers the threadlocal context
 */
class ThreadLocalDelegateExecutor<C> implements Executor
{
    private final Executor delegate;
    protected final ThreadLocalContextManager<C> manager;

    ThreadLocalDelegateExecutor(ThreadLocalContextManager<C> manager, Executor delegate)
    {
        this.delegate = checkNotNull(delegate);
        this.manager = checkNotNull(manager);
    }

    public void execute(Runnable runnable)
    {
        final Runnable wrapper = new ThreadLocalDelegateRunnable<C>(manager, runnable);
        delegate.execute(wrapper);
    }
}
