/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.core.rdbms;

import com.atlassian.fugue.Option;
import com.atlassian.sal.api.rdbms.ConnectionCallback;
import com.atlassian.sal.api.rdbms.RdbmsException;
import com.atlassian.sal.api.rdbms.TransactionalExecutor;
import com.atlassian.sal.core.rdbms.WrappedConnection;
import com.atlassian.sal.spi.HostConnectionAccessor;
import com.google.common.annotations.VisibleForTesting;
import java.sql.Connection;
import java.sql.SQLException;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTransactionalExecutor
implements TransactionalExecutor {
    private static final Logger log = LoggerFactory.getLogger(DefaultTransactionalExecutor.class);
    private final HostConnectionAccessor hostConnectionAccessor;
    @VisibleForTesting
    boolean readOnly;
    @VisibleForTesting
    boolean newTransaction;

    public DefaultTransactionalExecutor(@Nonnull HostConnectionAccessor hostConnectionAccessor, boolean readOnly, boolean newTransaction) {
        this.hostConnectionAccessor = hostConnectionAccessor;
        this.readOnly = readOnly;
        this.newTransaction = newTransaction;
    }

    public <A> A execute(final @Nonnull ConnectionCallback<A> callback) {
        return (A)this.hostConnectionAccessor.execute(this.readOnly, this.newTransaction, new ConnectionCallback<A>(){

            public A execute(Connection connection) {
                return DefaultTransactionalExecutor.this.executeInternal(connection, callback);
            }
        });
    }

    @Nonnull
    public Option<String> getSchemaName() {
        return this.hostConnectionAccessor.getSchemaName();
    }

    @Nonnull
    public TransactionalExecutor readOnly() {
        this.readOnly = true;
        return this;
    }

    @Nonnull
    public TransactionalExecutor readWrite() {
        this.readOnly = false;
        return this;
    }

    @Nonnull
    public TransactionalExecutor newTransaction() {
        this.newTransaction = true;
        return this;
    }

    @Nonnull
    public TransactionalExecutor existingTransaction() {
        this.newTransaction = false;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    <A> A executeInternal(@Nonnull Connection connection, @Nonnull ConnectionCallback<A> callback) {
        this.assertAutoCommitFalse(connection);
        try (WrappedConnection wrappedConnection = new WrappedConnection(connection);){
            Object result = callback.execute((Connection)wrappedConnection);
            try {
                connection.commit();
            }
            catch (Throwable se) {
                throw new RdbmsException("Unable to commit connection", se);
            }
            Object object = result;
            return (A)object;
        }
        catch (Throwable re) {
            try {
                connection.rollback();
                throw re;
            }
            catch (Throwable se) {
                re.addSuppressed(se);
            }
            throw re;
        }
    }

    private void assertAutoCommitFalse(Connection connection) {
        try {
            if (connection.getAutoCommit()) {
                throw new IllegalStateException("com.atlassian.sal.spi.HostConnectionAccessor returned connection with autocommit set");
            }
        }
        catch (SQLException e) {
            throw new RdbmsException("unable to invoke java.sql.Connection#getAutoCommit", (Throwable)e);
        }
    }
}

