/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.core.executor;

import com.atlassian.sal.api.executor.ThreadLocalDelegateExecutorFactory;
import java.util.Objects;
import java.util.concurrent.Executor;

class ThreadLocalDelegateExecutor
implements Executor {
    private final Executor delegate;
    private final ThreadLocalDelegateExecutorFactory delegateExecutorFactory;

    ThreadLocalDelegateExecutor(Executor delegate, ThreadLocalDelegateExecutorFactory delegateExecutorFactory) {
        this.delegateExecutorFactory = Objects.requireNonNull(delegateExecutorFactory);
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public void execute(Runnable runnable) {
        Runnable wrapper = this.delegateExecutorFactory.createRunnable(runnable);
        this.delegate.execute(wrapper);
    }
}

