/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pageobjects.components.aui;

import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.binder.Init;
import com.atlassian.pageobjects.components.ActivatedComponent;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Poller;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.openqa.selenium.By;

public class AuiDropDownMenu
implements ActivatedComponent<AuiDropDownMenu> {
    @Inject
    protected PageBinder pageBinder;
    @Inject
    protected PageElementFinder elementFinder;
    private final By locator;
    private PageElement rootElement;
    private PageElement triggerElement;
    private PageElement viewElement;

    public AuiDropDownMenu(By locator) {
        this.locator = locator;
    }

    @Init
    public void initialize() {
        this.rootElement = this.elementFinder.find(this.locator);
        this.triggerElement = this.rootElement.find(By.className((String)"aui-dd-trigger"));
        this.viewElement = this.rootElement.find(By.className((String)"aui-dropdown"));
    }

    @Override
    public PageElement getTrigger() {
        return this.triggerElement;
    }

    @Override
    public PageElement getView() {
        return this.viewElement;
    }

    @Override
    public AuiDropDownMenu open() {
        if (!this.isOpen()) {
            this.triggerElement.click();
            Poller.waitUntilTrue(this.viewElement.timed().isVisible());
        }
        return this;
    }

    public AuiDropDownMenu close() {
        if (this.isOpen()) {
            this.triggerElement.click();
            Poller.waitUntilTrue(this.viewElement.timed().isVisible());
        }
        return this;
    }

    @Override
    public boolean isOpen() {
        return this.viewElement.isVisible();
    }

    public List<String> getItems() {
        ArrayList<String> items = new ArrayList<String>();
        for (PageElement e : this.viewElement.findAll(By.tagName((String)"li"))) {
            items.add(e.getText());
        }
        return items;
    }
}

