/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pageobjects.elements;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.WebDriverElement;
import com.atlassian.webdriver.AtlassianWebDriver;
import javax.inject.Inject;
import org.openqa.selenium.Keys;
import org.openqa.selenium.interactions.Action;
import org.openqa.selenium.interactions.Actions;

public class PageElementActions {
    @Inject
    private AtlassianWebDriver webDriver;
    private Actions actions;

    private Actions getActions() {
        if (this.actions == null) {
            this.actions = new Actions(this.webDriver.getDriver());
        }
        return this.actions;
    }

    public PageElementActions keyDown(Keys theKey) {
        this.getActions().keyDown(theKey);
        return this;
    }

    public PageElementActions keyDown(PageElement element, Keys theKey) {
        this.getActions().keyDown(WebDriverElement.getWebElement(element), theKey);
        return this;
    }

    public PageElementActions keyUp(Keys theKey) {
        this.getActions().keyUp(theKey);
        return this;
    }

    public PageElementActions keyUp(PageElement element, Keys theKey) {
        this.getActions().keyUp(WebDriverElement.getWebElement(element), theKey);
        return this;
    }

    public PageElementActions sendKeys(CharSequence ... keysToSend) {
        this.getActions().sendKeys(keysToSend);
        return this;
    }

    public PageElementActions sendKeys(PageElement element, CharSequence ... keysToSend) {
        this.getActions().sendKeys(WebDriverElement.getWebElement(element), keysToSend);
        return this;
    }

    public PageElementActions clickAndHold(PageElement onElement) {
        this.getActions().clickAndHold(WebDriverElement.getWebElement(onElement));
        return this;
    }

    public PageElementActions clickAndHold() {
        this.getActions().clickAndHold();
        return this;
    }

    public PageElementActions release(PageElement onElement) {
        this.getActions().release(WebDriverElement.getWebElement(onElement));
        return this;
    }

    public PageElementActions release() {
        this.getActions().release();
        return this;
    }

    public PageElementActions click(PageElement onElement) {
        this.getActions().click(WebDriverElement.getWebElement(onElement));
        return this;
    }

    public PageElementActions click() {
        this.getActions().click();
        return this;
    }

    public PageElementActions doubleClick(PageElement onElement) {
        this.getActions().doubleClick(WebDriverElement.getWebElement(onElement));
        return this;
    }

    public PageElementActions doubleClick() {
        this.getActions().doubleClick();
        return this;
    }

    public PageElementActions moveToElement(PageElement toElement) {
        this.getActions().moveToElement(WebDriverElement.getWebElement(toElement));
        return this;
    }

    public PageElementActions moveToElement(PageElement toElement, int xOffset, int yOffset) {
        this.getActions().moveToElement(WebDriverElement.getWebElement(toElement), xOffset, yOffset);
        return this;
    }

    public PageElementActions moveByOffset(int xOffset, int yOffset) {
        this.getActions().moveByOffset(xOffset, yOffset);
        return this;
    }

    public PageElementActions contextClick(PageElement onElement) {
        this.getActions().contextClick(WebDriverElement.getWebElement(onElement));
        return this;
    }

    public PageElementActions dragAndDrop(PageElement source, PageElement target) {
        this.getActions().dragAndDrop(WebDriverElement.getWebElement(source), WebDriverElement.getWebElement(target));
        return this;
    }

    public PageElementActions dragAndDropBy(PageElement source, int xOffset, int yOffset) {
        this.getActions().dragAndDropBy(WebDriverElement.getWebElement(source), xOffset, yOffset);
        return this;
    }

    Action build() {
        return this.getActions().build();
    }

    public void perform() {
        this.getActions().perform();
    }

    public PageElementActions reset() {
        this.getActions().build();
        return this;
    }
}

