/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pageobjects.elements.query;

import com.atlassian.pageobjects.elements.query.AbstractTimedCondition;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.pageobjects.elements.util.StringConcat;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.ArrayUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.StringDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Conditions {
    private static final Logger log = LoggerFactory.getLogger(Conditions.class);
    private static final int DEFAULT_TIMEOUT = 100;

    private Conditions() {
        throw new AssertionError((Object)(Conditions.class.getName() + " should not be instantiated"));
    }

    @Nonnull
    public static TimedQuery<Boolean> not(@Nonnull TimedQuery<Boolean> condition) {
        if (condition instanceof Not) {
            return Conditions.asDecorator(condition).wrapped;
        }
        return new Not(condition);
    }

    @Nonnull
    public static CombinableCondition and(TimedQuery<Boolean> ... conditions) {
        return new And(conditions);
    }

    @Nonnull
    public static CombinableCondition and(@Nonnull Iterable<TimedQuery<Boolean>> conditions) {
        return Conditions.and((TimedQuery[])Iterables.toArray(conditions, TimedQuery.class));
    }

    @Nonnull
    public static CombinableCondition or(TimedQuery<Boolean> ... conditions) {
        return new Or(conditions);
    }

    @Nonnull
    public static CombinableCondition or(@Nonnull Iterable<TimedQuery<Boolean>> conditions) {
        return Conditions.or((TimedQuery[])Iterables.toArray(conditions, TimedQuery.class));
    }

    @Nonnull
    public static TimedCondition dependantCondition(@Nonnull TimedQuery<Boolean> original, @Nonnull Supplier<TimedQuery<Boolean>> dependant) {
        return new DependantCondition(original, dependant);
    }

    @Nonnull
    public static <T> TimedCondition forMatcher(@Nonnull TimedQuery<T> query, @Nonnull Matcher<? super T> matcher) {
        return new MatchingCondition<T>(query, matcher);
    }

    @Nonnull
    public static <T> TimedCondition isEqual(@Nullable T value, @Nonnull TimedQuery<T> query) {
        return Conditions.forMatcher(query, Matchers.equalTo(value));
    }

    @Nonnull
    public static TimedCondition forSupplier(@Nonnull Supplier<Boolean> supplier) {
        return Conditions.forSupplier(100L, supplier);
    }

    @Nonnull
    public static TimedCondition forSupplier(long defaultTimeout, final @Nonnull Supplier<Boolean> supplier) {
        return new AbstractTimedCondition(defaultTimeout, 100L){

            @Override
            protected Boolean currentValue() {
                return (Boolean)supplier.get();
            }
        };
    }

    @Nonnull
    public static TimedCondition forSupplier(@Nonnull Timeouts timeouts, @Nonnull Supplier<Boolean> supplier) {
        return Conditions.forSupplier(timeouts, supplier, TimeoutType.DEFAULT);
    }

    @Nonnull
    public static TimedCondition forSupplier(@Nonnull Timeouts timeouts, final @Nonnull Supplier<Boolean> supplier, @Nonnull TimeoutType timeoutType) {
        Preconditions.checkNotNull((Object)timeouts, (Object)"timeouts");
        Preconditions.checkNotNull(supplier, (Object)"supplier");
        Preconditions.checkNotNull((Object)((Object)timeoutType), (Object)"timeoutType");
        return new AbstractTimedCondition(timeouts.timeoutFor(timeoutType), timeouts.timeoutFor(TimeoutType.EVALUATION_INTERVAL)){

            @Override
            protected Boolean currentValue() {
                return (Boolean)supplier.get();
            }
        };
    }

    @Nonnull
    public static TimedCondition alwaysTrue() {
        return new StaticCondition(true);
    }

    @Nonnull
    public static TimedCondition alwaysFalse() {
        return new StaticCondition(false);
    }

    private static AbstractConditionDecorator asDecorator(TimedQuery<Boolean> condition) {
        return (AbstractConditionDecorator)condition;
    }

    static final class MatchingCondition<T>
    extends AbstractTimedCondition {
        final TimedQuery<T> query;
        final Matcher<? super T> matcher;
        T lastValue;

        public MatchingCondition(TimedQuery<T> query, Matcher<? super T> matcher) {
            super(query);
            this.query = (TimedQuery)Preconditions.checkNotNull(query);
            this.matcher = (Matcher)Preconditions.checkNotNull(matcher);
        }

        @Override
        protected Boolean currentValue() {
            try {
                this.lastValue = this.query.now();
                return this.matcher.matches(this.lastValue);
            }
            catch (Exception e) {
                log.debug(String.format("TimedQuery.now() threw an exception. Not a match for %s", this.matcher), (Throwable)e);
                return false;
            }
        }

        @Override
        public String toString() {
            return super.toString() + new StringDescription().appendText("[query=").appendValue(this.query).appendText("][matcher=").appendDescriptionOf(this.matcher).appendText("]");
        }
    }

    private static final class DependantCondition
    extends AbstractConditionDecorator {
        private final Supplier<TimedQuery<Boolean>> dependant;

        DependantCondition(TimedQuery<Boolean> original, Supplier<TimedQuery<Boolean>> dependant) {
            super(original);
            this.dependant = (Supplier)Preconditions.checkNotNull(dependant, (Object)"dependant");
        }

        @Override
        public Boolean currentValue() {
            return (Boolean)this.wrapped.now() != false && (Boolean)((TimedQuery)this.dependant.get()).now() != false;
        }

        @Override
        public String toString() {
            if (((Boolean)this.wrapped.now()).booleanValue()) {
                TimedQuery dep = (TimedQuery)this.dependant.get();
                return StringConcat.asString("DependantCondition[original=", this.wrapped, ",dependant=", dep, "]");
            }
            return StringConcat.asString("DependantCondition[original=", this.wrapped, "]");
        }
    }

    private static class Or
    extends AbstractConditionsDecorator {
        public Or(TimedQuery<Boolean> ... conditions) {
            super(conditions);
        }

        Or(TimedQuery<Boolean>[] somes, TimedQuery<Boolean>[] more) {
            super((TimedCondition[])ArrayUtils.addAll((Object[])somes, (Object[])more));
        }

        Or(TimedQuery<Boolean>[] somes, TimedQuery<Boolean> oneMore) {
            super((TimedCondition[])ArrayUtils.add((Object[])somes, oneMore));
        }

        @Override
        public Boolean currentValue() {
            boolean result = false;
            for (TimedQuery condition : this.conditions) {
                boolean bl = result = condition.now() != null ? (Boolean)condition.now() : false;
                if (result) break;
                log.debug(StringConcat.asString("[Or] Condition <", condition, "> returned false"));
            }
            return result;
        }

        @Override
        public CombinableCondition and(TimedCondition other) {
            if (other instanceof And) {
                return ((And)other).and(this);
            }
            return new And(this, other);
        }

        @Override
        public CombinableCondition or(TimedCondition other) {
            if (other.getClass().equals(Or.class)) {
                return new Or((TimedQuery<Boolean>[])this.conditions, (TimedQuery<Boolean>[])((Or)other).conditions);
            }
            return new Or((TimedQuery<Boolean>[])this.conditions, (TimedQuery<Boolean>)other);
        }
    }

    private static class And
    extends AbstractConditionsDecorator {
        public And(TimedQuery<Boolean> ... conditions) {
            super(conditions);
        }

        And(TimedQuery<Boolean>[] somes, TimedQuery<Boolean>[] more) {
            super((TimedCondition[])ArrayUtils.addAll((Object[])somes, (Object[])more));
        }

        And(TimedQuery<Boolean>[] somes, TimedQuery<Boolean> oneMore) {
            super((TimedCondition[])ArrayUtils.add((Object[])somes, oneMore));
        }

        @Override
        public Boolean currentValue() {
            boolean result = true;
            for (TimedQuery condition : this.conditions) {
                boolean bl = result = condition.now() != null ? (Boolean)condition.now() : false;
                if (result) continue;
                log.debug(StringConcat.asString("[And] Condition <", condition, "> returned false"));
                break;
            }
            return result;
        }

        @Override
        public CombinableCondition and(TimedCondition other) {
            if (other.getClass().equals(And.class)) {
                return new And((TimedQuery<Boolean>[])this.conditions, (TimedQuery<Boolean>[])((And)other).conditions);
            }
            return new And((TimedQuery<Boolean>[])this.conditions, (TimedQuery<Boolean>)other);
        }

        @Override
        public CombinableCondition or(TimedCondition other) {
            if (other instanceof Or) {
                return ((Or)other).or(this);
            }
            return new Or(this, other);
        }
    }

    private static class Not
    extends AbstractConditionDecorator {
        public Not(TimedQuery<Boolean> other) {
            super(other);
        }

        @Override
        public Boolean currentValue() {
            return (Boolean)this.wrapped.now() == false;
        }

        @Override
        public String toString() {
            return StringConcat.asString("Negated: <", this.wrapped, ">");
        }
    }

    private static abstract class AbstractConditionsDecorator
    extends AbstractTimedCondition
    implements CombinableCondition {
        protected final TimedQuery<Boolean>[] conditions;

        public AbstractConditionsDecorator(TimedQuery<Boolean> ... conditions) {
            super(conditions[0]);
            this.conditions = conditions;
        }

        @Override
        public String toString() {
            StringBuilder answer = new StringBuilder(this.conditions.length * 20).append(this.getClass().getName()).append(":\n");
            for (TimedQuery<Boolean> condition : this.conditions) {
                answer.append(" -").append(condition.toString()).append('\n');
            }
            return answer.deleteCharAt(answer.length() - 1).toString();
        }
    }

    private static abstract class AbstractConditionDecorator
    extends AbstractTimedCondition {
        protected final TimedQuery<Boolean> wrapped;

        public AbstractConditionDecorator(TimedQuery<Boolean> wrapped) {
            super(wrapped);
            this.wrapped = (TimedQuery)Preconditions.checkNotNull(wrapped, (Object)"wrapped");
        }
    }

    public static interface CombinableCondition
    extends TimedCondition {
        public CombinableCondition and(TimedCondition var1);

        public CombinableCondition or(TimedCondition var1);
    }

    private static class StaticCondition
    extends AbstractTimedCondition {
        private final Boolean value;

        public StaticCondition(Boolean value) {
            super(100L, 100L);
            this.value = (Boolean)Preconditions.checkNotNull((Object)value);
        }

        @Override
        protected Boolean currentValue() {
            return this.value;
        }
    }
}

