/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pageobjects.elements.query;

import com.atlassian.pageobjects.elements.query.TimedQuery;

public interface ExpirationHandler {
    public static final ExpirationHandler RETURN_CURRENT = new ExpirationHandler(){

        @Override
        public <T> T expired(TimedQuery<T> query, T currentValue, long timeout) {
            return currentValue;
        }
    };
    public static final ExpirationHandler RETURN_NULL = new ExpirationHandler(){

        @Override
        public <T> T expired(TimedQuery<T> query, T currentValue, long timeout) {
            return null;
        }
    };
    public static final ExpirationHandler THROW_ASSERTION_ERROR = new ExpirationHandler(){

        @Override
        public <T> T expired(TimedQuery<T> query, T currentValue, long timeout) {
            throw new AssertionError((Object)("Timeout <" + timeout + "> expired for: " + query));
        }
    };
    public static final ExpirationHandler THROW_ILLEGAL_STATE = new ExpirationHandler(){

        @Override
        public <T> T expired(TimedQuery<T> query, T currentValue, long timeout) {
            throw new IllegalStateException("Timeout <" + timeout + "> expired for: " + query);
        }
    };

    public <T> T expired(TimedQuery<T> var1, T var2, long var3);
}

