/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pageobjects.elements.query;

import com.atlassian.annotations.PublicApi;
import com.atlassian.pageobjects.elements.query.Conditions;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.StringDescription;

@PublicApi
public final class Poller {
    private Poller() {
        throw new AssertionError((Object)"Don't instantiate me");
    }

    public static void waitUntilTrue(TimedQuery<Boolean> condition) {
        Poller.waitUntil(condition, Matchers.is((Object)true));
    }

    public static void waitUntilTrue(String message, TimedQuery<Boolean> condition) {
        Poller.waitUntil(message, condition, Matchers.is((Object)true));
    }

    public static void waitUntilFalse(TimedQuery<Boolean> condition) {
        Poller.waitUntil(condition, Matchers.is((Object)false));
    }

    public static void waitUntilFalse(String message, TimedQuery<Boolean> condition) {
        Poller.waitUntil(message, condition, Matchers.is((Object)false));
    }

    public static <T> T waitUntilEquals(T expectedValue, TimedQuery<T> query) {
        return Poller.waitUntil(query, Matchers.equalTo(expectedValue));
    }

    public static <T> T waitUntilEquals(String message, T expectedValue, TimedQuery<T> query) {
        return Poller.waitUntil(message, query, Matchers.equalTo(expectedValue));
    }

    public static <T> T waitUntil(TimedQuery<T> query, Matcher<? super T> matcher) {
        return Poller.waitUntil(null, query, matcher, Poller.byDefaultTimeout());
    }

    public static <T> T waitUntil(String message, TimedQuery<T> query, Matcher<? super T> matcher) {
        return Poller.waitUntil(message, query, matcher, Poller.byDefaultTimeout());
    }

    public static <T> T waitUntil(TimedQuery<T> query, Matcher<? super T> matcher, WaitTimeout timeout) {
        return Poller.waitUntil(null, query, matcher, timeout);
    }

    public static <T> T waitUntil(String message, TimedQuery<T> query, Matcher<? super T> matcher, WaitTimeout timeout) {
        Preconditions.checkNotNull((Object)timeout);
        Conditions.MatchingCondition<? super T> assertion = new Conditions.MatchingCondition<T>(query, matcher);
        if (!timeout.evaluate(assertion)) {
            throw new AssertionError((Object)Poller.buildMessage(message, assertion, matcher, timeout));
        }
        return assertion.lastValue;
    }

    private static <T> String buildMessage(String message, Conditions.MatchingCondition<T> assertion, Matcher<? super T> matcher, WaitTimeout timeout) {
        StringDescription answer = new StringDescription();
        if (StringUtils.isNotEmpty((String)message)) {
            answer.appendText(message).appendText(":\n");
        }
        return answer.appendText("Query ").appendValue(assertion.query).appendText("\nExpected: ").appendDescriptionOf(matcher).appendText(timeout.msgTimeoutSuffix(assertion)).appendText("\nGot (last value): ").appendValue(assertion.lastValue).toString();
    }

    public static WaitTimeout now() {
        return new WaitTimeout(){

            @Override
            boolean evaluate(TimedCondition condition) {
                return (Boolean)condition.now();
            }

            @Override
            String msgTimeoutSuffix(TimedCondition condition) {
                return " immediately";
            }
        };
    }

    public static WaitTimeout byDefaultTimeout() {
        return new WaitTimeout(){

            @Override
            boolean evaluate(TimedCondition condition) {
                return (Boolean)condition.byDefaultTimeout();
            }

            @Override
            String msgTimeoutSuffix(TimedCondition condition) {
                return " by " + condition.defaultTimeout() + "ms (default timeout)";
            }
        };
    }

    public static WaitTimeout by(final long timeoutInMillis) {
        return new WaitTimeout(){

            @Override
            boolean evaluate(TimedCondition condition) {
                return (Boolean)condition.by(timeoutInMillis);
            }

            @Override
            String msgTimeoutSuffix(TimedCondition condition) {
                return " by " + timeoutInMillis + "ms";
            }
        };
    }

    public static WaitTimeout by(final long timeout, final TimeUnit unit) {
        return new WaitTimeout(){

            @Override
            boolean evaluate(TimedCondition condition) {
                return (Boolean)condition.by(timeout, unit);
            }

            @Override
            String msgTimeoutSuffix(TimedCondition condition) {
                return " by " + unit.toMillis(timeout) + "ms";
            }
        };
    }

    public static abstract class WaitTimeout {
        private WaitTimeout() {
        }

        abstract boolean evaluate(TimedCondition var1);

        abstract String msgTimeoutSuffix(TimedCondition var1);
    }
}

