/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pageobjects.elements.query.webdriver;

import com.atlassian.annotations.Internal;
import com.atlassian.pageobjects.elements.WebDriverLocatable;
import com.atlassian.pageobjects.elements.query.AbstractTimedQuery;
import com.atlassian.pageobjects.elements.query.ExpirationHandler;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.query.webdriver.WebDriverLocatableBasedTimedCondition;
import com.atlassian.pageobjects.elements.query.webdriver.WebDriverLocatableBasedTimedQuery;
import com.atlassian.pageobjects.elements.query.webdriver.WebDriverQueryFunctions;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.webdriver.AtlassianWebDriver;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;
import javax.inject.Inject;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriver;

@NotThreadSafe
@Internal
public class WebDriverQueryFactory {
    private final WebDriverLocatable locatable;
    @Inject
    private Timeouts timeouts;
    @Inject
    private AtlassianWebDriver webDriver;
    private long interval = -1L;

    public WebDriverQueryFactory(WebDriverLocatable locatable) {
        this.locatable = (WebDriverLocatable)Preconditions.checkNotNull((Object)locatable);
    }

    public WebDriverQueryFactory(WebDriverLocatable locatable, Timeouts timeouts, AtlassianWebDriver webDriver) {
        this.locatable = (WebDriverLocatable)Preconditions.checkNotNull((Object)locatable);
        this.timeouts = timeouts;
        this.webDriver = webDriver;
    }

    private long interval() {
        if (this.interval == -1L) {
            this.interval = this.timeouts.timeoutFor(TimeoutType.EVALUATION_INTERVAL);
            Preconditions.checkState((this.interval > 0L ? 1 : 0) != 0);
        }
        return this.interval;
    }

    public TimedCondition isPresent(TimeoutType timeoutType) {
        return new WebDriverLocatableBasedTimedCondition(this.locatable, this.webDriver, WebDriverQueryFunctions.isPresent(), this.timeouts.timeoutFor(timeoutType), this.interval());
    }

    public TimedCondition isPresent() {
        return this.isPresent(TimeoutType.DEFAULT);
    }

    public TimedCondition isVisible(TimeoutType timeoutType) {
        return new WebDriverLocatableBasedTimedCondition(this.locatable, this.webDriver, WebDriverQueryFunctions.isVisible(), this.timeouts.timeoutFor(timeoutType), this.interval());
    }

    public TimedCondition isVisible() {
        return this.isVisible(TimeoutType.DEFAULT);
    }

    public TimedCondition isEnabled(TimeoutType timeoutType) {
        return new WebDriverLocatableBasedTimedCondition(this.locatable, this.webDriver, WebDriverQueryFunctions.isEnabled(), this.timeouts.timeoutFor(timeoutType), this.interval());
    }

    public TimedCondition isEnabled() {
        return this.isEnabled(TimeoutType.DEFAULT);
    }

    public TimedCondition isSelected(TimeoutType timeoutType) {
        return new WebDriverLocatableBasedTimedCondition(this.locatable, this.webDriver, WebDriverQueryFunctions.isSelected(), this.timeouts.timeoutFor(timeoutType), this.interval());
    }

    public TimedCondition isSelected() {
        return this.isSelected(TimeoutType.DEFAULT);
    }

    public TimedQuery<String> getText(TimeoutType timeoutType) {
        return new WebDriverLocatableBasedTimedQuery<String>(this.locatable, (WebDriver)this.webDriver, WebDriverQueryFunctions.getText(), this.timeouts.timeoutFor(timeoutType), this.interval());
    }

    public TimedQuery<String> getText() {
        return this.getText(TimeoutType.DEFAULT);
    }

    public TimedQuery<String> getValue(TimeoutType timeoutType) {
        return new WebDriverLocatableBasedTimedQuery<String>(this.locatable, (WebDriver)this.webDriver, WebDriverQueryFunctions.getValue(), this.timeouts.timeoutFor(timeoutType), this.interval());
    }

    public TimedQuery<String> getValue() {
        return this.getValue(TimeoutType.DEFAULT);
    }

    public TimedCondition hasAttribute(String attributeName, String expectedValue, TimeoutType timeoutType) {
        return new WebDriverLocatableBasedTimedCondition(this.locatable, this.webDriver, WebDriverQueryFunctions.hasAttribute(attributeName, expectedValue), this.timeouts.timeoutFor(timeoutType), this.interval());
    }

    public TimedCondition hasAttribute(String attributeName, String expectedValue) {
        return this.hasAttribute(attributeName, expectedValue, TimeoutType.DEFAULT);
    }

    public TimedQuery<String> getAttribute(String attributeName, TimeoutType timeoutType) {
        return new WebDriverLocatableBasedTimedQuery<String>(this.locatable, (WebDriver)this.webDriver, WebDriverQueryFunctions.getAttribute(attributeName), this.timeouts.timeoutFor(timeoutType), this.interval());
    }

    public TimedQuery<String> getAttribute(String attributeName) {
        return this.getAttribute(attributeName, TimeoutType.DEFAULT);
    }

    public TimedQuery<Set<String>> getCssClasses(TimeoutType timeoutType) {
        return new WebDriverLocatableBasedTimedQuery<Set<String>>(this.locatable, (WebDriver)this.webDriver, WebDriverQueryFunctions.getCssClasses(), this.timeouts.timeoutFor(timeoutType), this.interval());
    }

    public TimedCondition hasClass(String className, TimeoutType timeoutType) {
        return new WebDriverLocatableBasedTimedCondition(this.locatable, this.webDriver, WebDriverQueryFunctions.hasClass(className), this.timeouts.timeoutFor(timeoutType), this.interval());
    }

    public TimedCondition hasClass(String className) {
        return this.hasClass(className, TimeoutType.DEFAULT);
    }

    public TimedQuery<String> getTagName(TimeoutType timeoutType) {
        return new WebDriverLocatableBasedTimedQuery<String>(this.locatable, (WebDriver)this.webDriver, WebDriverQueryFunctions.getTagName(), this.timeouts.timeoutFor(timeoutType), this.interval());
    }

    public TimedQuery<String> getTagName() {
        return this.getTagName(TimeoutType.DEFAULT);
    }

    public TimedCondition hasText(String text, TimeoutType timeoutType) {
        return new WebDriverLocatableBasedTimedCondition(this.locatable, this.webDriver, WebDriverQueryFunctions.hasText(text), this.timeouts.timeoutFor(timeoutType), this.interval());
    }

    public TimedCondition hasText(String text) {
        return this.hasText(text, TimeoutType.DEFAULT);
    }

    public TimedCondition hasValue(String value, TimeoutType timeoutType) {
        return new WebDriverLocatableBasedTimedCondition(this.locatable, this.webDriver, WebDriverQueryFunctions.hasValue(value), this.timeouts.timeoutFor(timeoutType), this.interval());
    }

    public TimedCondition hasValue(String value) {
        return this.hasValue(value, TimeoutType.DEFAULT);
    }

    public TimedQuery<Point> getLocation(TimeoutType timeoutType) {
        return new WebDriverLocatableBasedTimedQuery<Point>(this.locatable, (WebDriver)this.webDriver, WebDriverQueryFunctions.getLocation(), this.timeouts.timeoutFor(timeoutType), this.interval());
    }

    public TimedQuery<Dimension> getSize(TimeoutType timeoutType) {
        return new WebDriverLocatableBasedTimedQuery<Dimension>(this.locatable, (WebDriver)this.webDriver, WebDriverQueryFunctions.getSize(), this.timeouts.timeoutFor(timeoutType), this.interval());
    }

    public <T> TimedQuery<T> forSupplier(final Supplier<T> supplier, TimeoutType timeoutType) {
        return new AbstractTimedQuery<T>(this.timeouts.timeoutFor(timeoutType), 100L, ExpirationHandler.RETURN_CURRENT){

            @Override
            protected boolean shouldReturn(T currentEval) {
                return true;
            }

            @Override
            protected T currentValue() {
                return supplier.get();
            }
        };
    }

    public <T> TimedQuery<T> forSupplier(Supplier<T> supplier) {
        return this.forSupplier(supplier, TimeoutType.DEFAULT);
    }
}

