/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pageobjects.elements.timeout;

import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class MapBasedTimeouts
implements Timeouts {
    private final Map<TimeoutType, Long> timeouts;
    private final long defaultValue;

    public MapBasedTimeouts(Map<TimeoutType, Long> timeouts) {
        this.timeouts = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(timeouts)));
        this.defaultValue = this.validateAndGetDefault();
    }

    private long validateAndGetDefault() {
        Preconditions.checkArgument((boolean)this.timeouts.containsKey((Object)TimeoutType.DEFAULT), (Object)"Must contain default timeout value");
        Preconditions.checkArgument((this.timeouts.get((Object)TimeoutType.DEFAULT) != null ? 1 : 0) != 0, (Object)"Must contain non-null default timeout value");
        return this.timeouts.get((Object)TimeoutType.DEFAULT);
    }

    @Override
    public long timeoutFor(TimeoutType timeoutType) {
        Long timeout = this.timeouts.get((Object)timeoutType);
        if (timeout != null) {
            return timeout;
        }
        if (TimeoutType.EVALUATION_INTERVAL == timeoutType) {
            return 100L;
        }
        return this.defaultValue;
    }
}

