/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver;

import com.atlassian.annotations.PublicApi;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

@PublicApi
public final class Elements {
    public static final String TAG_BODY = "body";
    public static final String TAG_DIV = "div";
    public static final String TAG_TR = "tr";
    public static final String TAG_TD = "td";
    public static final String TAG_UL = "ul";
    public static final String TAG_LI = "li";
    public static final String ATTRIBUTE_CLASS = "class";
    public static final String ATTRIBUTE_ID = "id";

    private Elements() {
        throw new AssertionError((Object)("Do not instantiate " + this.getClass().getSimpleName()));
    }

    @Nonnull
    public static Set<String> getCssClasses(@Nullable String rawClassValue) {
        if (StringUtils.isBlank((String)rawClassValue)) {
            return Collections.emptySet();
        }
        return FluentIterable.from((Iterable)ImmutableSet.copyOf((Object[])rawClassValue.split("\\s+"))).transform((Function)new Function<String, String>(){

            @Nullable
            public String apply(@Nullable String cssClass) {
                return StringUtils.isBlank((String)cssClass) ? null : cssClass.toLowerCase();
            }
        }).filter(Predicates.notNull()).toSet();
    }

    public static boolean hasCssClass(@Nonnull String expectedClassName, @Nullable String rawClassValue) {
        Preconditions.checkNotNull((Object)expectedClassName, (Object)"className");
        return rawClassValue != null && Elements.getCssClasses(rawClassValue).contains(expectedClassName.toLowerCase());
    }
}

