/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.visualcomparison;

import com.atlassian.selenium.visualcomparison.ScreenElement;
import com.atlassian.selenium.visualcomparison.VisualComparableClient;
import com.atlassian.selenium.visualcomparison.utils.ScreenResolution;
import com.atlassian.webdriver.AtlassianWebDriver;
import com.google.common.base.Function;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class WebDriverVisualComparableClient
implements VisualComparableClient {
    private final AtlassianWebDriver driver;
    private Dimension documentSize;
    private Dimension viewportSize;

    public WebDriverVisualComparableClient(AtlassianWebDriver driver) {
        this.driver = driver;
    }

    public void captureEntirePageScreenshot(String filePath) {
        this.driver.takeScreenshotTo(new File(filePath));
        this.documentSize = this.getDimensionsFor("document");
        this.viewportSize = this.getDimensionsFor("window");
    }

    private Dimension getDimensionsFor(String selector) {
        int x = Integer.parseInt(this.execute("return jQuery(" + selector + ").width();", new Object[0]).toString());
        int y = Integer.parseInt(this.execute("return jQuery(" + selector + ").height();", new Object[0]).toString());
        return new Dimension(x, y);
    }

    public ScreenElement getElementAtPoint(int x, int y) {
        int deltaY = this.documentSize.height - this.viewportSize.height;
        int scrollY = Math.min(deltaY, y);
        int relY = y - scrollY;
        int deltaX = this.documentSize.width - this.viewportSize.width;
        int scrollX = Math.min(deltaX, x);
        int relX = x - scrollX;
        this.execute(String.format("window.scrollTo(%d,%d)", scrollX, scrollY), new Object[0]);
        WebElement el = this.driver.findElement(this.atPointInDom(relX, relY));
        return new WebDriverScreenElement(el);
    }

    private By atPointInDom(int relX, int relY) {
        String domSel = String.format("return document.elementFromPoint(%d,%d);", relX, relY);
        final Object o = this.driver.executeScript(domSel, new Object[0]);
        if (o instanceof WebElement) {
            return new By(){

                public List<WebElement> findElements(SearchContext searchContext) {
                    return new ArrayList<WebElement>(){
                        {
                            this.add((WebElement)o);
                        }
                    };
                }
            };
        }
        return null;
    }

    public void evaluate(String command) {
        this.execute(command, new Object[0]);
    }

    public Object execute(String command, Object ... arguments) {
        return this.driver.executeScript(command, arguments);
    }

    public boolean resizeScreen(ScreenResolution resolution, boolean refresh) {
        this.driver.getDriver().manage().window().setSize(new Dimension(resolution.width, resolution.height));
        this.viewportSize = this.getDimensionsFor("window");
        if (refresh) {
            this.refreshAndWait();
        }
        return true;
    }

    public void refreshAndWait() {
        this.driver.navigate().refresh();
    }

    public boolean waitForJQuery(long waitTimeMillis) {
        try {
            this.driver.waitUntil(new Function<WebDriver, Boolean>(){

                public Boolean apply(WebDriver webDriver) {
                    String jQueryActive = ((JavascriptExecutor)webDriver).executeScript("return (window.jQuery.active)", new Object[0]).toString();
                    return jQueryActive.equals("0");
                }
            }, (int)waitTimeMillis);
            Thread.sleep(400L);
        }
        catch (InterruptedException e) {
            return false;
        }
        return true;
    }

    private class WebDriverScreenElement
    implements ScreenElement {
        private final WebElement element;

        WebDriverScreenElement(WebElement el) {
            this.element = el;
        }

        @Nonnull
        public String getHtml() {
            return (String)WebDriverVisualComparableClient.this.execute("var d = document.createElement('div'); d.appendChild(arguments[0].cloneNode(true)); return d.innerHTML;", this.element);
        }
    }
}

