/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.waiter.webdriver;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.webdriver.AtlassianWebDriver;
import com.atlassian.webdriver.waiter.Query;
import com.atlassian.webdriver.waiter.webdriver.WebDriverWaiterQuery;
import com.atlassian.webdriver.waiter.webdriver.function.ConditionFunction;
import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.WebDriver;

@ExperimentalApi
class WebDriverQueryBuilder {
    private final AtlassianWebDriver driver;
    private final long timeout;
    List<Query> queries = new ArrayList<Query>();

    public WebDriverQueryBuilder(AtlassianWebDriver driver, long timeout) {
        this.driver = driver;
        this.timeout = timeout;
    }

    public WebDriverQueryBuilder add(Query query) {
        this.queries.add(query);
        return this;
    }

    public Function<WebDriver, Boolean> build() {
        ConditionFunction builtFunction = null;
        for (int i = 0; i < this.queries.size(); ++i) {
            ConditionFunction func;
            ConditionFunction nextFunc;
            Query query = this.queries.get(i);
            if (this.isAndQuery(query)) {
                nextFunc = this.queries.get(++i).build();
                func = new AndFunction(builtFunction, nextFunc);
            } else if (this.isOrQuery(query)) {
                nextFunc = this.queries.get(++i).build();
                func = new OrFunction(builtFunction, nextFunc);
            } else {
                func = query.build();
            }
            builtFunction = func;
        }
        return builtFunction;
    }

    public AtlassianWebDriver getDriver() {
        return this.driver;
    }

    public long getTimeout() {
        return this.timeout;
    }

    private boolean isAndQuery(Query query) {
        return query.getClass().isAssignableFrom(WebDriverWaiterQuery.AndQuery.class);
    }

    private boolean isOrQuery(Query query) {
        return query.getClass().isAssignableFrom(WebDriverWaiterQuery.OrQuery.class);
    }

    private static class OrFunction
    implements ConditionFunction {
        private final Function<WebDriver, Boolean> func1;
        private final Function<WebDriver, Boolean> func2;

        public OrFunction(Function<WebDriver, Boolean> func1, Function<WebDriver, Boolean> func2) {
            this.func1 = func1;
            this.func2 = func2;
        }

        public Boolean apply(WebDriver driver) {
            return (Boolean)this.func1.apply((Object)driver) != false || (Boolean)this.func2.apply((Object)driver) != false;
        }
    }

    private static class AndFunction
    implements ConditionFunction {
        private final Function<WebDriver, Boolean> func1;
        private final Function<WebDriver, Boolean> func2;

        public AndFunction(Function<WebDriver, Boolean> func1, Function<WebDriver, Boolean> func2) {
            this.func1 = func1;
            this.func2 = func2;
        }

        public Boolean apply(WebDriver driver) {
            return (Boolean)this.func1.apply((Object)driver) != false && (Boolean)this.func2.apply((Object)driver) != false;
        }
    }
}

