/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.waiter.webdriver.retriever;

import com.atlassian.webdriver.waiter.webdriver.retriever.Supplier;
import com.atlassian.webdriver.waiter.webdriver.retriever.WebElementRetriever;
import com.google.common.base.Preconditions;

public class WebElementFieldRetriever {
    private final Supplier<String> fieldSupplier;

    private WebElementFieldRetriever(Supplier<String> fieldSupplier) {
        this.fieldSupplier = (Supplier)Preconditions.checkNotNull(fieldSupplier, (Object)"The field supplier can not be null.");
    }

    public static WebElementFieldRetriever newTextRetriever(final WebElementRetriever webElementRetriever) {
        Preconditions.checkNotNull((Object)webElementRetriever, (Object)"The web element retriever can not be null.");
        return new WebElementFieldRetriever(new Supplier<String>(){

            @Override
            public String supply() {
                return webElementRetriever.retrieveElement().getText();
            }
        });
    }

    public static WebElementFieldRetriever newAttributeRetriever(final WebElementRetriever webElementRetriever, final String fieldName) {
        Preconditions.checkNotNull((Object)webElementRetriever, (Object)"The web element retriever can not be null.");
        Preconditions.checkNotNull((Object)fieldName, (Object)"The field name can not be null.");
        return new WebElementFieldRetriever(new Supplier<String>(){

            @Override
            public String supply() {
                return webElementRetriever.retrieveElement().getAttribute(fieldName);
            }
        });
    }

    public String retrieveField() {
        return this.fieldSupplier.supply();
    }
}

