/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.project;

import com.atlassian.stash.project.ProjectType;
import com.atlassian.stash.project.ProjectVisitor;
import com.atlassian.stash.validation.OptionalString;
import com.atlassian.stash.validation.RequiredString;
import com.atlassian.stash.validation.groups.Create;
import com.atlassian.stash.validation.groups.Update;
import javax.annotation.Nonnull;
import javax.validation.constraints.Pattern;

public interface Project {
    public static final String KEY_REGEXP = "[a-zA-Z][a-zA-Z0-9_\\-]*";
    public static final int MAX_KEY_LENGTH = 128;

    public <T> T accept(@Nonnull ProjectVisitor<T> var1);

    @OptionalString(size=255)
    public String getDescription();

    public Integer getId();

    @Deprecated
    public boolean getIsPersonal();

    public boolean isPublic();

    @Pattern(regexp="[a-zA-Z][a-zA-Z0-9_\\-]*", groups={Create.class, Update.class}, message="{com.atlassian.stash.validation.project.key.pattern.message}")
    @RequiredString(size=128)
    public String getKey();

    @RequiredString(size=128)
    public String getName();

    @Nonnull
    public ProjectType getType();
}

