/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.project;

import com.atlassian.stash.project.Project;
import com.atlassian.stash.project.ProjectSearchCriteria;
import com.atlassian.stash.user.Permission;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ProjectSearchRequest
extends ProjectSearchCriteria {
    private ProjectSearchRequest(String name, Permission permission) {
        super(name, permission);
    }

    public static class Builder {
        private String name;
        private Permission permission;

        public Builder() {
        }

        public Builder(@Nonnull ProjectSearchRequest request) {
            this.name = ((ProjectSearchRequest)Preconditions.checkNotNull((Object)request, (Object)"request")).getName();
            this.permission = request.getPermission();
        }

        @Nonnull
        public ProjectSearchRequest build() {
            return new ProjectSearchRequest(this.name, this.permission);
        }

        @Nonnull
        public Builder name(@Nullable String value) {
            this.name = value;
            return this;
        }

        @Nonnull
        public Builder permission(@Nullable Permission value) {
            Preconditions.checkArgument((value == null || value.isResource(Project.class) ? 1 : 0) != 0, (Object)"The provided permission is not valid for projects");
            this.permission = value;
            return this;
        }
    }
}

