/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.pull;

import com.atlassian.stash.content.AttributeSupport;
import com.atlassian.stash.pull.PullRequestParticipant;
import com.atlassian.stash.pull.PullRequestRef;
import com.atlassian.stash.pull.PullRequestState;
import com.atlassian.stash.validation.OptionalString;
import com.atlassian.stash.validation.RequiredString;
import com.atlassian.stash.watcher.Watchable;
import com.google.common.base.Function;
import java.util.Date;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface PullRequest
extends AttributeSupport,
Watchable {
    public static final Function<PullRequest, Long> TO_ID = new Function<PullRequest, Long>(){

        public Long apply(PullRequest pullRequest) {
            return pullRequest.getId();
        }
    };

    @Nonnull
    public PullRequestParticipant getAuthor();

    @Nonnull
    public Date getCreatedDate();

    @Nullable
    @OptionalString(size=32768)
    public String getDescription();

    @Nonnull
    public PullRequestRef getFromRef();

    @Nullable
    public Long getId();

    @Nonnull
    public Set<PullRequestParticipant> getParticipants();

    @Nonnull
    public Set<PullRequestParticipant> getReviewers();

    @Nonnull
    public PullRequestState getState();

    @Nonnull
    @RequiredString
    public String getTitle();

    @Nonnull
    public PullRequestRef getToRef();

    @Nonnull
    public Date getUpdatedDate();

    public int getVersion();

    public boolean isClosed();

    public boolean isCrossRepository();

    public boolean isOpen();
}

