/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.pull;

import com.atlassian.stash.pull.AbstractPullRequestRequest;
import com.atlassian.stash.pull.PullRequest;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class PullRequestUpdateRequest
extends AbstractPullRequestRequest {
    private final String description;
    private final Set<String> reviewers;
    private final String title;
    private final String toBranchId;
    private final int version;

    private PullRequestUpdateRequest(int repositoryId, long pullRequestId, int version, String title, String description, Set<String> reviewers, String toBranchId) {
        super(repositoryId, pullRequestId);
        this.version = version;
        this.title = title;
        this.description = description;
        this.reviewers = reviewers;
        this.toBranchId = toBranchId;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nonnull
    public Set<String> getReviewers() {
        return this.reviewers;
    }

    @Nonnull
    public String getTitle() {
        return this.title;
    }

    @Nullable
    public String getToBranchId() {
        return this.toBranchId;
    }

    public int getVersion() {
        return this.version;
    }

    public static class Builder
    extends AbstractPullRequestRequest.AbstractBuilder<Builder> {
        private int version;
        private String title;
        private String description;
        private Set<String> reviewers = ImmutableSet.of();
        private String toBranchId;

        public Builder(int repositoryId, long pullRequestId, int version) {
            super(repositoryId, pullRequestId);
            this.version = version;
        }

        public Builder(PullRequest pullRequest, int version) {
            super(pullRequest);
            this.version = version;
        }

        public PullRequestUpdateRequest build() {
            if (StringUtils.isBlank((String)this.title)) {
                throw new IllegalStateException("A \"title\" is required to update a pull request");
            }
            return new PullRequestUpdateRequest(this.repositoryId, this.pullRequestId, this.version, this.title, this.description, this.reviewers, this.toBranchId);
        }

        public Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        public Builder reviewers(@Nonnull Iterable<String> value) {
            this.reviewers = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(value, (Object)"value")));
            return this;
        }

        public Builder title(@Nonnull String value) {
            if (StringUtils.isBlank((String)value)) {
                throw new IllegalStateException("\"title\" cannot be blank");
            }
            this.title = value;
            return this;
        }

        public Builder toBranchId(@Nullable String value) {
            if (value != null && StringUtils.isBlank((String)value)) {
                throw new IllegalStateException("A \"toBranchId\" cannot be blank");
            }
            this.toBranchId = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

