/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.pull;

import com.atlassian.stash.pull.AbstractPullRequestRequest;
import com.atlassian.stash.pull.PullRequest;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;

public class PullRequestChangesRequest
extends AbstractPullRequestRequest {
    private final boolean withComments;

    private PullRequestChangesRequest(Builder builder) {
        super(builder);
        this.withComments = builder.withComments;
    }

    public boolean isWithComments() {
        return this.withComments;
    }

    public static class Builder
    extends AbstractPullRequestRequest.AbstractBuilder<Builder> {
        private boolean withComments;

        public Builder(@Nonnull PullRequestChangesRequest request) {
            super(((PullRequestChangesRequest)Preconditions.checkNotNull((Object)request, (Object)"request")).getRepositoryId(), request.getPullRequestId());
            this.withComments = request.isWithComments();
        }

        public Builder(@Nonnull PullRequest pullRequest) {
            this(((PullRequest)Preconditions.checkNotNull((Object)pullRequest, (Object)"pullRequest")).getToRef().getRepository().getId(), pullRequest.getId());
        }

        public Builder(int repositoryId, long pullRequestId) {
            super(repositoryId, pullRequestId);
            this.withComments = true;
        }

        @Nonnull
        public PullRequestChangesRequest build() {
            return new PullRequestChangesRequest(this);
        }

        @Nonnull
        public Builder withComments(boolean value) {
            this.withComments = value;
            return this.self();
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

