/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.repository;

import com.atlassian.stash.repository.RefOrder;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.util.BuilderSupport;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractRepositoryRefsRequest {
    private final Repository repository;
    private final String filterText;
    private final RefOrder order;

    protected AbstractRepositoryRefsRequest(AbstractBuilder<?, ?> builder) {
        this.repository = ((AbstractBuilder)builder).repository;
        this.filterText = ((AbstractBuilder)builder).filterText;
        this.order = ((AbstractBuilder)builder).order;
        Preconditions.checkState((this.repository != null ? 1 : 0) != 0, (Object)(this.getClass().getSimpleName() + " requires a repository."));
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    @Nullable
    public String getFilterText() {
        return this.filterText;
    }

    @Nullable
    public RefOrder getOrder() {
        return this.order;
    }

    public static abstract class AbstractBuilder<B extends AbstractBuilder<B, R>, R extends AbstractRepositoryRefsRequest>
    extends BuilderSupport {
        private Repository repository;
        private String filterText;
        private RefOrder order;

        protected AbstractBuilder() {
        }

        protected AbstractBuilder(@Nonnull Repository repository) {
            this.repository = (Repository)Preconditions.checkNotNull((Object)repository, (Object)"repository");
        }

        @Nonnull
        public abstract R build();

        @Nonnull
        public B filterText(@Nullable String value) {
            this.filterText = value;
            return this.self();
        }

        @Nonnull
        public B order(@Nullable RefOrder value) {
            this.order = value;
            return this.self();
        }

        @Nonnull
        public B repository(@Nonnull Repository value) {
            this.repository = (Repository)Preconditions.checkNotNull((Object)value, (Object)"repository");
            return this.self();
        }

        @Nonnull
        protected abstract B self();
    }
}

