/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.test;

import com.atlassian.stash.async.AsyncTestUtils;
import com.atlassian.stash.async.WaitCondition;
import com.atlassian.stash.test.DefaultFuncTestData;
import com.jayway.restassured.RestAssured;
import com.jayway.restassured.http.ContentType;
import com.jayway.restassured.response.Response;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import net.sf.json.JSONObject;
import org.hamcrest.Description;

public class AnalyticsTestHelper {
    private static final long MAX_WAIT_TIME = 1000L;

    public static void enableEventLogging() {
        AnalyticsTestHelper.setEventLoggingEnabled(true);
        AnalyticsTestHelper.clearEventLog();
    }

    public static void disableEventLogging() {
        AnalyticsTestHelper.setEventLoggingEnabled(false);
    }

    private static void clearEventLog() {
        RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).expect().log().ifError().statusCode(Response.Status.OK.getStatusCode()).when().delete(AnalyticsTestHelper.getReportUrl(), new Object[0]);
    }

    private static void setEventLoggingEnabled(boolean enabled) {
        RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).body(new JSONObject().accumulate("capturing", enabled).toString()).contentType(ContentType.JSON).expect().log().ifError().statusCode(Response.Status.OK.getStatusCode()).when().put(AnalyticsTestHelper.getReportUrl(), new Object[0]);
    }

    private static String getReportUrl() {
        return DefaultFuncTestData.getRestURL("analytics", "latest") + "/report";
    }

    private static Map<String, Object> findWhitelistedEventFromRest(String expectedEventName) {
        Response response = (Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).queryParam("mode", new Object[]{"btf_processed"}).expect().log().ifError().statusCode(Response.Status.OK.getStatusCode()).when().get(AnalyticsTestHelper.getReportUrl(), new Object[0]);
        List events = response.getBody().jsonPath().getList("events");
        for (Map event : events) {
            if (!expectedEventName.equals(event.get("name")) || !"false".equalsIgnoreCase(event.get("removed").toString())) continue;
            return event;
        }
        return null;
    }

    public static Map<String, Object> findWhitelistedEvent(final String expectedEventName) {
        WaitCondition eventExists = new WaitCondition(){

            public boolean test() throws Exception {
                return AnalyticsTestHelper.findWhitelistedEventFromRest(expectedEventName) != null;
            }

            public void describeFailure(Description description) throws Exception {
                description.appendText("Cannot find event: ").appendValue((Object)expectedEventName);
            }
        };
        AsyncTestUtils.waitFor((WaitCondition)eventExists, (long)1000L);
        return AnalyticsTestHelper.findWhitelistedEventFromRest(expectedEventName);
    }
}

