/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.test;

import com.atlassian.stash.test.DefaultFuncTestData;
import com.atlassian.stash.test.Timeouts;
import com.jayway.restassured.RestAssured;
import com.jayway.restassured.http.ContentType;
import com.jayway.restassured.response.Response;
import com.jayway.restassured.response.ValidatableResponse;
import java.util.concurrent.Callable;
import javax.ws.rs.core.Response;

public class BatchNotificationTestHelper {
    private static final int FLUSH_SETTLE_DELAY = 500;
    private static final int NOTIFICATION_ARRIVAL_TIMEOUT = 1000;

    public static int getBatchNotificationCount() {
        Response response = (Response)RestAssured.expect().contentType(ContentType.JSON).statusCode(Response.Status.OK.getStatusCode()).given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).get(DefaultFuncTestData.getRestURL("notification", "latest") + "/batch", new Object[0]);
        return response.body().jsonPath().getInt("count");
    }

    public static boolean waitUntilBatchNotificationCount(final int count) throws Exception {
        return Timeouts.doUntil(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                int currentCount = BatchNotificationTestHelper.getBatchNotificationCount();
                return currentCount == count;
            }
        }, 1000L);
    }

    public static void flushBatchNotificationQueue() throws InterruptedException {
        Thread.sleep(500L);
        long time = System.currentTimeMillis() + 3600000L;
        ((ValidatableResponse)((Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType(ContentType.JSON).when().post(DefaultFuncTestData.getRestURL("notification", "latest") + "/batch/process?time=" + time, new Object[0])).then().statusCode(Response.Status.NO_CONTENT.getStatusCode())).log().ifValidationFails();
    }
}

