/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.test;

import com.atlassian.stash.content.DiffSegmentType;
import com.atlassian.stash.test.DefaultFuncTestData;
import com.atlassian.stash.test.Timeouts;
import com.atlassian.stash.test.rest.ResponseMatchers;
import com.atlassian.stash.test.rest.comment.RestCommentUtils;
import com.jayway.restassured.RestAssured;
import com.jayway.restassured.http.ContentType;
import com.jayway.restassured.response.Response;
import java.util.concurrent.Callable;
import net.sf.json.JSONObject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.rules.ExternalResource;

public final class CommitCommentTestHelper
extends ExternalResource {
    private final String projectKey;
    private final String repositorySlug;
    private final String commitHash;

    public CommitCommentTestHelper(String projectKey, String repositorySlug, String commitHash) {
        this.projectKey = projectKey;
        this.repositorySlug = repositorySlug;
        this.commitHash = commitHash;
    }

    public boolean deleteCommitCommentAndWait(int commentID, int commentVersion) throws Exception {
        return this.deleteCommitCommentAndWait(commentID, commentVersion, 2500L);
    }

    public boolean deleteCommitCommentAndWait(int commentID, int commentVersion, long maxWaitTime) throws Exception {
        final String url = DefaultFuncTestData.getRestURL() + "/projects/" + this.projectKey + "/repos/" + this.repositorySlug + "/commits/" + this.commitHash + "/comments/" + commentID + "?version=" + commentVersion;
        RestAssured.expect().statusCode((Matcher)Matchers.anyOf(ResponseMatchers.accepted(), ResponseMatchers.noContent())).given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).when().delete(url, new Object[0]);
        return Timeouts.doUntil(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                Response response = (Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).when().get(url, new Object[0]);
                return ResponseMatchers.notFound().matches((Object)response.getStatusCode());
            }
        }, maxWaitTime);
    }

    public int addCommitComment(String commentText, String filePath, int lineNo, DiffSegmentType segmentType, String username, String password) {
        String url = DefaultFuncTestData.getRestURL() + "/projects/" + this.projectKey + "/repos/" + this.repositorySlug + "/commits/" + this.commitHash + "/comments";
        JSONObject body = RestCommentUtils.createLineBody(commentText, filePath, filePath, lineNo, segmentType);
        Response response = (Response)RestAssured.given().auth().preemptive().basic(username, password).body((Object)body).contentType(ContentType.JSON).when().post(url, new Object[0]);
        return response.jsonPath().getInt("id");
    }
}

