/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.test;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class GitTestHelper {
    private static String gitPath;

    private GitTestHelper() {
        throw new UnsupportedOperationException(GitTestHelper.class.getName() + " should not be instantiated");
    }

    public static Map<String, String> createCommitterEnv() {
        return GitTestHelper.withCommitterInfo(System.getenv());
    }

    public static String getGitPath() {
        if (gitPath == null) {
            gitPath = (String)Objects.firstNonNull((Object)System.getenv("GIT_PATH"), (Object)"git");
        }
        return gitPath;
    }

    private static Map<String, String> withCommitterInfo(Map<String, String> env) {
        return ImmutableMap.builder().putAll(env).put((Object)"GIT_COMMITTER_NAME", (Object)"Stash Func Test Runner").put((Object)"GIT_COMMITTER_EMAIL", (Object)"stash-dev@atlassian.com").put((Object)"GIT_AUTHOR_NAME", (Object)"Stash Func Test Runner").put((Object)"GIT_AUTHOR_EMAIL", (Object)"stash-dev@atlassian.com").build();
    }
}

