/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.test;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;

public class NavigationTestHelper {
    public static <T> void testNavigation(List<T> items, Function<NavigationOptions, Void> navigateToNext, Function<NavigationOptions, Void> navigateToPrev, Function<T, Void> assertHasFocus) {
        for (Object item : items) {
            navigateToNext.apply((Object)new NavigationOptions(true));
            assertHasFocus.apply(item);
        }
        navigateToNext.apply((Object)new NavigationOptions(false));
        assertHasFocus.apply(items.get(items.size() - 1));
        for (Object item : Lists.reverse(items).subList(1, items.size())) {
            navigateToPrev.apply((Object)new NavigationOptions(true));
            assertHasFocus.apply(item);
        }
        navigateToPrev.apply((Object)new NavigationOptions(false));
        assertHasFocus.apply(items.get(0));
    }

    public static class NavigationOptions {
        private boolean expectingMovement;

        public NavigationOptions(boolean expectingMovement) {
            this.expectingMovement = expectingMovement;
        }

        public boolean isExpectingMovement() {
            return this.expectingMovement;
        }
    }
}

