/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.test;

import com.atlassian.stash.test.ProcessResult;
import com.atlassian.utils.process.ExternalProcess;
import com.atlassian.utils.process.StringProcessHandler;

public class ProcessFailedException
extends RuntimeException
implements ProcessResult {
    private final String stdErr;
    private final String output;
    private final int exitCode;

    public ProcessFailedException(ExternalProcess process, StringProcessHandler handler) {
        super(ProcessFailedException.buildMessage(process, handler), (Throwable)handler.getException());
        this.stdErr = handler.getError();
        this.output = handler.getOutput();
        this.exitCode = handler.getExitCode();
    }

    private static String buildMessage(ExternalProcess process, StringProcessHandler handler) {
        return process.getCommandLine() + " failed (" + handler.getExitCode() + ") out:" + handler.getOutput() + ": err:" + handler.getError() + ":";
    }

    @Override
    public String getStdErr() {
        return this.stdErr;
    }

    @Override
    public String getStdOut() {
        return this.output;
    }

    @Override
    public int getExitCode() {
        return this.exitCode;
    }
}

