/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.test;

import com.atlassian.stash.test.ProcessFailedException;
import com.atlassian.stash.test.ProcessResult;
import com.atlassian.utils.process.ExternalProcess;
import com.atlassian.utils.process.StringProcessHandler;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessResultFactory {
    private static final Logger log = LoggerFactory.getLogger(ProcessResultFactory.class);

    public static ProcessResult createOrThrow(ExternalProcess process, StringProcessHandler handler) throws ProcessFailedException {
        if (handler.getExitCode() != 0) {
            log.error("Execution failed: {} ({})", (Object)process.getCommandLine(), (Object)handler.getExitCode());
            if (!log.isDebugEnabled() && StringUtils.isNotBlank((String)handler.getOutput())) {
                log.error("StdOut:\n{}", (Object)handler.getOutput());
            }
            log.error("StdErr:\n{}", (Object)handler.getError());
            log.error("Exception:", (Throwable)handler.getException());
            throw new ProcessFailedException(process, handler);
        }
        return new ProcessFailedException(process, handler);
    }

    public static ProcessResult flatten(ProcessResult ... results) {
        return new AggregatedProcessResult(results);
    }

    private static class AggregatedProcessResult
    implements ProcessResult {
        private final List<ProcessResult> results;

        public AggregatedProcessResult(ProcessResult ... results) {
            this.results = Arrays.asList(results);
            for (ProcessResult result : results) {
                Preconditions.checkArgument((result.getExitCode() == 0 ? 1 : 0) != 0);
            }
        }

        @Override
        public String getStdErr() {
            StringBuilder sb = new StringBuilder();
            for (ProcessResult result : this.results) {
                sb.append(result.getStdErr());
            }
            return sb.toString();
        }

        @Override
        public String getStdOut() {
            StringBuilder sb = new StringBuilder();
            for (ProcessResult result : this.results) {
                sb.append(result.getStdOut());
            }
            return sb.toString();
        }

        @Override
        public int getExitCode() {
            return 0;
        }
    }
}

