/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.test;

import com.atlassian.stash.test.ProductTopologyVisitor;
import java.util.Locale;

public enum ProductTopology {
    STASH_STANDALONE("stash.standalone"){

        @Override
        public <T> T accept(ProductTopologyVisitor<T> visitor) {
            return visitor.visitStashStandalone();
        }
    }
    ,
    STASH_CLUSTER_PAIR("stash.cluster.pair"){

        @Override
        public <T> T accept(ProductTopologyVisitor<T> visitor) {
            return visitor.visitStashClusterPair();
        }
    };

    private final String propertyName;

    private ProductTopology(String propertyName) {
        this.propertyName = propertyName;
    }

    public abstract <T> T accept(ProductTopologyVisitor<T> var1);

    public static ProductTopology get() {
        String value = System.getProperty("test.product.topology", ProductTopology.STASH_STANDALONE.propertyName).toLowerCase(Locale.US).trim();
        for (ProductTopology topology : ProductTopology.values()) {
            if (!topology.propertyName.equals(value)) continue;
            return topology;
        }
        return STASH_STANDALONE;
    }
}

