/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.test;

import com.atlassian.stash.content.DiffFileType;
import com.atlassian.stash.content.DiffSegmentType;
import com.atlassian.stash.test.DefaultFuncTestData;
import com.atlassian.stash.test.RestTestHelper;
import com.atlassian.stash.test.rest.comment.RestCommentUtils;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.jayway.restassured.RestAssured;
import com.jayway.restassured.builder.ResponseSpecBuilder;
import com.jayway.restassured.response.Response;
import com.jayway.restassured.specification.ResponseSpecification;
import java.util.Arrays;
import javax.ws.rs.core.Response;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.mutable.MutableLong;

public class PullRequestRestTestHelper {
    public static long createComment(String projectKey, String repoSlug, long pullRequestId, String username, String password, JSONObject body, String commentText) {
        MutableLong commentId = new MutableLong();
        RestAssured.expect().spec(PullRequestRestTestHelper.createCommentSpecWithNoReplies(Response.Status.CREATED, commentId, commentText, username)).log().ifError().given().auth().preemptive().basic(username, password).contentType("application/json").body((Object)body).post(PullRequestRestTestHelper.getPullRequestCommentsURL(projectKey, repoSlug, pullRequestId), new Object[0]);
        return commentId.longValue();
    }

    public static void addWatcher(String projectKey, String repoSlug, long pullRequestId, String username, String password) {
        RestAssured.expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).log().ifError().given().auth().preemptive().basic(username, password).contentType("application/json").when().post(PullRequestRestTestHelper.getPullRequestWatchURL(projectKey, repoSlug, pullRequestId), new Object[0]);
    }

    public static void removeWatcher(String projectKey, String repoSlug, long pullRequestId, String username, String password) {
        RestAssured.expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).log().ifError().given().auth().preemptive().basic(username, password).contentType("application/json").when().delete(PullRequestRestTestHelper.getPullRequestWatchURL(projectKey, repoSlug, pullRequestId), new Object[0]);
    }

    @Deprecated
    public static ResponseSpecBuilder createCommentSpecBuilder(Response.Status status, MutableLong commentId, String text, String authorName) {
        return RestCommentUtils.createSpecBuilder(status, commentId, text, authorName);
    }

    @Deprecated
    public static ResponseSpecification createCommentSpecWithNoReplies(Response.Status status, MutableLong commentId, String text, String authorName) {
        return RestCommentUtils.createSpecBuilderWithNoReplies(status, commentId, text, authorName).build();
    }

    public static JSONObject createCreateBody(String title, String description, String fromProjectKey, String fromRepoSlug, String fromBranchId, String toProjectKey, String toRepoSlug, String toBranchId) {
        JSONObject bodyObject = new JSONObject();
        bodyObject.put((Object)"title", (Object)title);
        bodyObject.put((Object)"description", (Object)description);
        bodyObject.put((Object)"fromRef", (Object)PullRequestRestTestHelper.createRefBody(fromProjectKey, fromRepoSlug, fromBranchId));
        bodyObject.put((Object)"toRef", (Object)PullRequestRestTestHelper.createRefBody(toProjectKey, toRepoSlug, toBranchId));
        return bodyObject;
    }

    @Deprecated
    public static JSONObject createFileLevelCommentBody(String text, String path, String srcPath) {
        return RestCommentUtils.createFileBody(text, path, srcPath);
    }

    @Deprecated
    public static JSONObject createLineLevelCommentBody(String text, String path, String srcPath, int line, DiffSegmentType lineType) {
        return RestCommentUtils.createLineBody(text, path, srcPath, line, lineType);
    }

    @Deprecated
    public static JSONObject createLineLevelCommentBody(String text, String path, String srcPath, int line, DiffSegmentType lineType, DiffFileType fileType) {
        return RestCommentUtils.createLineBody(text, path, srcPath, line, lineType, fileType);
    }

    public static Response createPullRequest(MutableLong id, String username, String password, String title, String description, String fromProjectKey, String fromRepoSlug, String fromBranchId, String toProjectKey, String toRepoSlug, String toBranchId, ResponseSpecification spec, String ... reviewers) {
        JSONObject body = PullRequestRestTestHelper.createCreateBody(title, description, fromProjectKey, fromRepoSlug, fromBranchId, toProjectKey, toRepoSlug, toBranchId);
        body.put((Object)"reviewers", (Object)Lists.transform(Arrays.asList(reviewers), (Function)new Function<String, JSONObject>(){

            public JSONObject apply(String reviewer) {
                return new JSONObject().accumulate("user", (Object)new JSONObject().accumulate("name", (Object)reviewer));
            }
        }));
        return (Response)RestAssured.expect().spec(spec).log().ifError().body("id", RestTestHelper.captureLongId(id), new Object[0]).given().auth().preemptive().basic(username, password).body(body.toString()).contentType("application/json").when().post(DefaultFuncTestData.getRestURL() + "/projects/" + toProjectKey + "/repos/" + toRepoSlug + "/pull-requests", new Object[0]);
    }

    @Deprecated
    public static JSONObject createPullRequestLevelCommentBody(String text) {
        return RestCommentUtils.createBody(text);
    }

    @Deprecated
    public static JSONObject createPullRequestLevelCommentBody(String text, int version) {
        return RestCommentUtils.createBodyWithVersion(text, version);
    }

    @Deprecated
    public static JSONObject createReplyBody(String text, long parentId) {
        return RestCommentUtils.createReplyBody(text, parentId);
    }

    public static JSONObject createUpdateBody(String title, String description, Integer version) {
        JSONObject bodyObject = new JSONObject();
        bodyObject.put((Object)"title", (Object)title);
        bodyObject.put((Object)"description", (Object)description);
        if (version != null) {
            bodyObject.put((Object)"version", (Object)version);
        }
        return bodyObject;
    }

    public static JSONObject createUpdateReviewersBody(Integer version, String ... usernames) {
        JSONObject bodyObject = new JSONObject();
        JSONArray reviewers = new JSONArray();
        for (String username : usernames) {
            JSONObject reviewer = new JSONObject();
            JSONObject user = new JSONObject();
            user.put((Object)"name", (Object)username);
            reviewer.put((Object)"user", (Object)user);
            reviewers.add((Object)reviewer);
        }
        bodyObject.put((Object)"reviewers", (Object)reviewers);
        if (version != null) {
            bodyObject.put((Object)"version", (Object)version);
        }
        return bodyObject;
    }

    public static JSONObject createUpdateBody(String newState, Integer version) {
        JSONObject bodyObject = new JSONObject();
        if (version != null) {
            bodyObject.put((Object)"version", (Object)version);
        }
        bodyObject.put((Object)"state", (Object)newState);
        return bodyObject;
    }

    public static JSONObject createUpdateBody(String newTitle, String newDescription, String newState, Integer version) {
        JSONObject bodyObject = new JSONObject();
        bodyObject.put((Object)"title", (Object)newTitle);
        bodyObject.put((Object)"description", (Object)newDescription);
        if (version != null) {
            bodyObject.put((Object)"version", (Object)version);
        }
        bodyObject.put((Object)"state", (Object)newState);
        return bodyObject;
    }

    public static String getPullRequestCommentURL(String projectKey, String repoSlug, long pullRequestId, long commentId, int version) {
        return PullRequestRestTestHelper.getPullRequestCommentsURL(projectKey, repoSlug, pullRequestId) + "/" + commentId + "?version=" + version;
    }

    public static String getPullRequestCommentsURL(String projKey, String repoSlug, long pullRequestId) {
        return RestCommentUtils.getPullRequestCommentsUrl(projKey, repoSlug, pullRequestId);
    }

    private static JSONObject createRefBody(String projectKey, String repoSlug, String branchId) {
        JSONObject ref = new JSONObject();
        ref.put((Object)"id", (Object)branchId);
        if (projectKey != null || repoSlug != null) {
            if (projectKey == null || repoSlug == null) {
                throw new IllegalArgumentException("When specifying a repository, both project key and repository slug are required");
            }
            JSONObject proj = new JSONObject();
            proj.put((Object)"key", (Object)projectKey);
            JSONObject repo = new JSONObject();
            repo.put((Object)"slug", (Object)repoSlug);
            repo.put((Object)"project", (Object)proj);
            ref.put((Object)"repository", (Object)repo);
        }
        return ref;
    }

    public static String getPullRequestWatchURL(String projectKey, String repoSlug, long pullRequestId) {
        return PullRequestRestTestHelper.getPullRequestURL(projectKey, repoSlug, pullRequestId) + "/watch";
    }

    public static String getPullRequestURL(String projectKey, String repoSlug, long id) {
        return PullRequestRestTestHelper.getPullRequestsURL(projectKey, repoSlug) + "/" + id;
    }

    public static String getPullRequestsURL(String projectKey, String repoSlug) {
        return DefaultFuncTestData.getRestURL() + "/projects/" + projectKey + "/repos/" + repoSlug + "/pull-requests";
    }

    public static String getPullRequestViewURL(String projectKey, String repoSlug, long id) {
        return DefaultFuncTestData.getBaseURL() + "/projects/" + projectKey + "/repos/" + repoSlug + "/pull-requests/" + id;
    }
}

