/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.test;

import com.atlassian.stash.test.DefaultFuncTestData;
import com.atlassian.stash.test.GitTestHelper;
import com.atlassian.stash.test.ProcessTestHelper;
import com.atlassian.stash.test.RepositoryTestHelper;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.junit.Ignore;
import org.junit.rules.ExternalResource;
import org.junit.rules.TemporaryFolder;

@Ignore
public class ReadmeRepoRule
extends ExternalResource {
    private final TemporaryFolder folder = new TemporaryFolder();
    public final String project;
    public final String repo;

    public ReadmeRepoRule() {
        this(DefaultFuncTestData.getProject1(), "readme_1");
    }

    public ReadmeRepoRule(String project, String repo) {
        this.project = project;
        this.repo = repo;
    }

    public void before() throws Exception {
        this.folder.create();
        this.createWithDir(this.folder.getRoot());
    }

    private void createWithDir(File repDir) throws Exception {
        ProcessTestHelper.execute(repDir, GitTestHelper.getGitPath(), "init");
        ReadmeRepoRule.writeStringToFile(new File(repDir, "README.md"), "#test");
        ReadmeRepoRule.writeStringToFile(new File(repDir, "a/readme.md"), "#testa");
        ReadmeRepoRule.writeStringToFile(new File(repDir, "b/notreadme.md"), "#testb");
        ReadmeRepoRule.writeStringToFile(new File(repDir, "binary/README.md"), "#test\u0000");
        ProcessTestHelper.execute(repDir, GitTestHelper.getGitPath(), "add", ".");
        ProcessTestHelper.execute(repDir, GitTestHelper.createCommitterEnv(), GitTestHelper.getGitPath(), "commit", "-m", "First commit");
        ProcessTestHelper.execute(repDir, GitTestHelper.getGitPath(), "branch", "first");
        ReadmeRepoRule.writeStringToFile(new File(repDir, "README.md"), "#test2");
        ProcessTestHelper.execute(repDir, GitTestHelper.createCommitterEnv(), GitTestHelper.getGitPath(), "commit", "-a", "-m", "Second commit");
        RepositoryTestHelper.createRepository(this.project, this.repo);
        RepositoryTestHelper.pushRep(repDir, DefaultFuncTestData.getBaseURL(), DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword(), this.project, this.repo);
    }

    protected void after() {
        this.folder.delete();
        RepositoryTestHelper.deleteRepository(this.project, this.repo);
    }

    private static void writeStringToFile(File file, String string) {
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            throw new IllegalStateException("Could not create parent directory for " + file);
        }
        try {
            FileUtils.writeStringToFile((File)file, (String)string);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

