/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.test;

import com.atlassian.stash.async.AsyncTestUtils;
import com.atlassian.stash.async.WaitCondition;
import com.atlassian.stash.test.DefaultFuncTestData;
import com.atlassian.stash.test.GitTestHelper;
import com.atlassian.stash.test.ProcessTestHelper;
import com.atlassian.stash.test.ProjectTestHelper;
import com.atlassian.stash.test.RestTestHelper;
import com.atlassian.stash.test.Timeouts;
import com.atlassian.stash.util.FileUtils;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import com.jayway.restassured.RestAssured;
import com.jayway.restassured.path.json.JsonPath;
import com.jayway.restassured.response.Response;
import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.ws.rs.core.Response;
import net.sf.json.JSONObject;
import org.hamcrest.Description;
import org.junit.Assert;
import org.junit.rules.TemporaryFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public final class RepositoryTestHelper {
    public static final String DEFAULT_REPOSITORY = "git/default-repository.zip";
    public static final String PULL_REQUEST_REPOSITORY = "git/pull-requests.zip";
    public static final String QA_RESOURCES_REPOSITORY = "git/qa-resources.zip";
    public static final String ENV_AUTHOR_EMAIL = "GIT_AUTHOR_EMAIL";
    public static final String ENV_AUTHOR_NAME = "GIT_AUTHOR_NAME";
    private static final Logger log = LoggerFactory.getLogger(RepositoryTestHelper.class);

    private RepositoryTestHelper() {
        throw new UnsupportedOperationException("Static utility class - not for instantiation");
    }

    public static void pushRep(TemporaryFolder temporaryFolder, String baseUrl, String user, String password, String project, String repository, Resource repoZipResource) throws IOException, URISyntaxException {
        RepositoryTestHelper.pushRep(temporaryFolder, baseUrl, user, password, project, repository, repoZipResource, (Function<? super ProcessTestHelper, Object>)Functions.constant(null));
    }

    public static void pushRep(TemporaryFolder temporaryFolder, String baseUrl, String user, String password, String project, String repository, Resource repoZipResource, Function<? super ProcessTestHelper, Object> callback) throws IOException, URISyntaxException {
        File repDir = new File(temporaryFolder.newFolder(project), repository);
        TFile.cp_r((File)new TFile(repoZipResource.getFile()), (File)repDir, (TArchiveDetector)TArchiveDetector.ALL);
        callback.apply((Object)new ProcessTestHelper(repDir));
        RepositoryTestHelper.pushRep(repDir, baseUrl, user, password, project, repository);
    }

    public static void pushEmptyRep(String baseUrl, String user, String password, String project, String repository) throws IOException, URISyntaxException {
        File repDir = RepositoryTestHelper.createTempRepoFolder(project, repository);
        ProcessTestHelper.execute(repDir, GitTestHelper.getGitPath(), "init");
        RepositoryTestHelper.pushRep(repDir, baseUrl, user, password, project, repository);
    }

    public static void pushRep(File repDir, String baseUrl, String user, String password, String project, String repository) throws IOException, URISyntaxException {
        URI authedUri = RepositoryTestHelper.getAuthenticatedURI(user, password, new URI(baseUrl));
        ProcessTestHelper.execute(repDir, GitTestHelper.getGitPath(), "remote", "add", "origin", authedUri.toString() + "/scm/" + project + "/" + repository + ".git");
        ProcessTestHelper.execute(repDir, GitTestHelper.getGitPath(), "push", "-f", "--all", "origin");
        ProcessTestHelper.execute(repDir, GitTestHelper.getGitPath(), "push", "-f", "--tags", "origin");
    }

    public static String pushCommit(String baseUrl, String user, String password, String project, String repository, String branch, String commitAuthorName, String commitAuthorEmail, String pathName, String filename, String content, String message) throws IOException, URISyntaxException {
        return RepositoryTestHelper.pushCommits(baseUrl, user, password, project, repository, branch, commitAuthorName, commitAuthorEmail, pathName, filename, content, message, 1);
    }

    public static String pushCommits(String baseUrl, String user, String password, String project, String repository, String branch, String commitAuthorName, String commitAuthorEmail, String pathName, String filename, String content, String message, int count) throws IOException, URISyntaxException {
        File repDir = RepositoryTestHelper.createTempRepoFolder(project, repository);
        URI authedUri = RepositoryTestHelper.getAuthenticatedURI(user, password, new URI(baseUrl));
        ProcessTestHelper.execute(repDir, GitTestHelper.getGitPath(), "clone", "--branch", branch, "--", authedUri.toString() + "/scm/" + project + "/" + repository + ".git", ".");
        for (int i = 0; i < count; ++i) {
            File newFileDir = FileUtils.construct((File)repDir, (String[])pathName.split("/"));
            FileUtils.mkdir((File)newFileDir);
            File tempFile = new File(newFileDir, RepositoryTestHelper.appendIndex(filename, i, count));
            Files.write((CharSequence)RepositoryTestHelper.appendIndex(content, i, count), (File)tempFile, (Charset)StandardCharsets.UTF_8);
            ImmutableMap env = ImmutableMap.of((Object)ENV_AUTHOR_EMAIL, (Object)commitAuthorEmail, (Object)ENV_AUTHOR_NAME, (Object)commitAuthorName);
            ProcessTestHelper.execute(repDir, GitTestHelper.getGitPath(), "add", tempFile.getCanonicalPath());
            ProcessTestHelper.execute(repDir, (Map<String, String>)env, GitTestHelper.getGitPath(), "commit", "-m", RepositoryTestHelper.appendIndex(message, i, count));
        }
        ProcessTestHelper.execute(repDir, GitTestHelper.getGitPath(), "push", "origin");
        return ProcessTestHelper.execute(repDir, GitTestHelper.getGitPath(), "rev-parse", "HEAD").getStdOut().trim();
    }

    public static String getSlugFromResponse(Response response) {
        return (String)response.getBody().jsonPath().get("slug");
    }

    public static Response getRepository(String projectKey, String repositorySlug) {
        return RepositoryTestHelper.getRepository("/projects/" + projectKey + "/repos/" + repositorySlug);
    }

    public static Response getRepository(String repoPath) {
        String url = DefaultFuncTestData.getRestURL() + repoPath;
        return (Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).when().get(url, new Object[0]);
    }

    public static Response createRepository(String projectKey, String repositoryName) {
        return RepositoryTestHelper.createRepositoryAtPath("/projects/" + projectKey + "/repos/", RepositoryTestHelper.createRepositoryBody(repositoryName));
    }

    public static Response createRepositoryAtPath(String projectPath, JSONObject bodyObject) {
        return (Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).body(bodyObject.toString()).contentType("application/json").expect().statusCode(Response.Status.CREATED.getStatusCode()).log().ifError().when().post(DefaultFuncTestData.getRestURL() + projectPath, new Object[0]);
    }

    public static Response createRepositoryAndWait(String projectKey, String repositoryName) {
        return RepositoryTestHelper.createRepositoryAndWait(projectKey, repositoryName, 2500L);
    }

    public static Response createPersonalRepositoryAndWait(String userSlug, String repositoryName, long maxWaitTime) {
        return RepositoryTestHelper.createRepositoryAtPathAndWait("/users/" + userSlug, repositoryName, maxWaitTime, RepositoryTestHelper.createRepositoryBody(repositoryName));
    }

    public static Response createRepositoryAndWait(String projectKey, String repositoryName, long maxWaitTime) {
        return RepositoryTestHelper.createRepositoryAndWait(projectKey, repositoryName, maxWaitTime, RepositoryTestHelper.createRepositoryBody(repositoryName));
    }

    public static Response createRepositoryAndWait(String projectKey, String repositoryName, long maxWaitTime, JSONObject repositoryBody) {
        return RepositoryTestHelper.createRepositoryAtPathAndWait("/projects/" + projectKey, repositoryName, maxWaitTime, repositoryBody);
    }

    public static Response createRepositoryAtPathAndWait(final String projectPath, String repositoryName, final long maxWaitTime, JSONObject repositoryBody) {
        Response response = RepositoryTestHelper.createRepositoryAtPath(projectPath + "/repos/", repositoryBody);
        final String repositorySlug = response.jsonPath().getString("slug");
        AsyncTestUtils.waitFor((WaitCondition)new WaitCondition(){

            public boolean test() {
                Response response = RepositoryTestHelper.getRepository(projectPath + "/repos/" + repositorySlug);
                if (response.getStatusCode() == 200) {
                    String repoState = (String)JsonPath.from((String)response.asString()).get("state");
                    return !"Initialising".endsWith(repoState);
                }
                return false;
            }

            public void describeFailure(Description description) throws Exception {
                description.appendText("The repository did not become available within ").appendValue((Object)maxWaitTime).appendText(" milliseconds");
            }
        }, (long)maxWaitTime);
        return response;
    }

    public static JSONObject createRepositoryBody(String repositoryName) {
        JSONObject bodyObject = new JSONObject();
        if (repositoryName != null) {
            bodyObject.put((Object)"name", (Object)repositoryName);
        }
        bodyObject.put((Object)"scmId", (Object)"git");
        return bodyObject;
    }

    public static JSONObject createRepositoryBody(@Nonnull String projectKey, @Nonnull String repoSlug) {
        JSONObject bodyObject = new JSONObject();
        bodyObject.put((Object)"project", (Object)ProjectTestHelper.createProjectBody(projectKey));
        bodyObject.put((Object)"slug", (Object)repoSlug);
        return bodyObject;
    }

    public static Response deletePersonalRepository(String repositorySlug, String username, String password) {
        return (Response)RestAssured.given().auth().preemptive().basic(username, password).when().delete(DefaultFuncTestData.getRestURL() + "/projects/~" + username + "/repos/" + repositorySlug, new Object[0]);
    }

    public static Response deleteRepository(String projectKey, String repositorySlug) {
        return (Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).when().delete(DefaultFuncTestData.getRestURL() + "/projects/" + projectKey + "/repos/" + repositorySlug, new Object[0]);
    }

    public static boolean deleteRepositoryAndWait(String projectKey, String repositorySlug) throws Exception {
        return RepositoryTestHelper.deleteRepositoryAndWait(projectKey, repositorySlug, 2500L);
    }

    public static boolean deleteRepositoryAndWait(String projectKey, String repositorySlug, long maxWaitTime) throws Exception {
        Response response = RepositoryTestHelper.deleteRepository(projectKey, repositorySlug);
        if (response.getStatusCode() != 202 && response.getStatusCode() != 204) {
            Assert.fail((String)(projectKey + "/" + repositorySlug + " could not be deleted; the delete request failed." + " statusCode = " + response.getStatusCode() + " body = " + response.prettyPrint()));
        }
        final String url = DefaultFuncTestData.getRestURL() + "/projects/" + projectKey + "/repos/" + repositorySlug;
        return Timeouts.doUntil(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                Response response = (Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).when().get(url, new Object[0]);
                return response.getStatusCode() == 404;
            }
        }, maxWaitTime);
    }

    public static void initRepository(String projectKey, String projectName, String repoSlug, String zipClasspathEntry) throws Exception {
        Response response = ProjectTestHelper.createProject(projectKey, projectName, "Project for commit list func testing");
        if (response.statusCode() != 201 && response.statusCode() != 409) {
            Assert.fail((String)("Attempting to create the test project failed with status code " + response.statusCode()));
        }
        if ((response = RepositoryTestHelper.createRepositoryAndWait(projectKey, repoSlug)).statusCode() != 201 && response.statusCode() != 409) {
            Assert.fail((String)("Attempting to create the test repository failed with status code " + response.statusCode()));
        }
        TemporaryFolder temporaryFolder = new TemporaryFolder();
        temporaryFolder.create();
        ClassPathResource repositoryResource = new ClassPathResource(zipClasspathEntry);
        RepositoryTestHelper.pushRep(temporaryFolder, DefaultFuncTestData.getBaseURL(), DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword(), projectKey, repoSlug, (Resource)repositoryResource);
    }

    public static void destroyRepository(String projectKey, String repoSlug) throws Exception {
        Response response;
        boolean success = RepositoryTestHelper.deleteRepositoryAndWait(projectKey, repoSlug);
        if (!success) {
            Assert.fail((String)("Attempting to delete the test repo " + projectKey + " : " + repoSlug));
        }
        if (((response = ProjectTestHelper.deleteProject(projectKey)).statusCode() < 200 || response.statusCode() > 299) && response.statusCode() != 409) {
            Assert.fail((String)("Attempting to delete the test project failed with status code " + response.statusCode()));
        }
    }

    public static boolean hasBranch(String projectKey, String repositorySlug, String branch) {
        Response response = (Response)RestAssured.given().queryParam("start", new Object[]{0}).queryParam("limit", new Object[]{100}).queryParam("filterText", new Object[]{branch}).auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).when().get(DefaultFuncTestData.getRestURL() + "/projects/" + projectKey + "/repos/" + repositorySlug + "/branches", new Object[0]);
        return RestTestHelper.hasValue(response, "displayId", branch, true);
    }

    public static Response forkRepository(String projectKey, String repositoryName, String username, String password) {
        return RepositoryTestHelper.forkRepositoryAndWait(projectKey, repositoryName, username, password, 2500L);
    }

    public static Response forkRepositoryAndWait(String projectKey, String repositoryName, String username, String password, long maxWaitTime) {
        String sourceRepoUrl = DefaultFuncTestData.getRestURL() + "/projects/" + projectKey + "/repos/" + repositoryName;
        Response response = (Response)RestAssured.expect().statusCode(201).log().ifError().given().contentType("application/json").body("{}").auth().preemptive().basic(username, password).when().post(sourceRepoUrl, new Object[0]);
        String forkedRepoUrl = DefaultFuncTestData.getRestURL() + "/projects/~" + username + "/repos/" + repositoryName;
        RepositoryTestHelper.waitForFork(forkedRepoUrl, maxWaitTime, username, password);
        return response;
    }

    public static Response forkNonPersonalRepositoryAndWait(String projectKey, String repoKey, String destProjectKey, String destRepoKey, long maxWaitTime) {
        String sourceRepoUrl = DefaultFuncTestData.getRestURL() + "/projects/" + projectKey + "/repos/" + repoKey;
        RestAssured.enableLoggingOfRequestAndResponseIfValidationFails();
        Response response = (Response)RestAssured.expect().statusCode(201).log().ifError().given().contentType("application/json").body("{\"slug\":\"" + destRepoKey + "\",\"name\":\"" + destRepoKey + "\",\"project\":{\"key\":\"" + destProjectKey + "\"}}").auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).when().post(sourceRepoUrl, new Object[0]);
        String forkedRepoUrl = DefaultFuncTestData.getRestURL() + "/projects/" + destProjectKey + "/repos/" + destRepoKey;
        RepositoryTestHelper.waitForFork(forkedRepoUrl, maxWaitTime, DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword());
        return response;
    }

    private static void waitForFork(final String forkedRepoUrl, final long maxWaitTime, final String username, final String password) {
        AsyncTestUtils.waitFor((WaitCondition)new WaitCondition(){

            public boolean test() {
                Response response = (Response)RestAssured.given().auth().preemptive().basic(username, password).when().get(forkedRepoUrl, new Object[0]);
                if (response.getStatusCode() == 200) {
                    String repoState = (String)JsonPath.from((String)response.asString()).get("state");
                    return !"Initialising".endsWith(repoState);
                }
                return false;
            }

            public void describeFailure(Description description) throws Exception {
                description.appendText("The forked repository did not become available within ").appendValue((Object)maxWaitTime).appendText(" milliseconds");
            }
        }, (long)maxWaitTime);
    }

    public static Response updateRepository(String projectKey, String repositorySlug, String body) {
        return (Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).body(body).contentType("application/json").expect().statusCode(Response.Status.OK.getStatusCode()).when().put(DefaultFuncTestData.getRestURL() + "/projects/" + projectKey + "/repos/" + repositorySlug, new Object[0]);
    }

    public static Response setRepositoryPublicAccessEnabled(String projectKey, String repositorySlug, boolean enabled) {
        return RepositoryTestHelper.updateRepository(projectKey, repositorySlug, "{ \"public\" : \"" + enabled + "\" }");
    }

    public static Response updateRepositorySlug(String projectKey, String originalRepoSlug, String newRepoName) {
        return RepositoryTestHelper.moveRepository(projectKey, originalRepoSlug, projectKey, newRepoName);
    }

    public static Response moveRepository(String originalProjectKey, String originalRepoSlug, String newProjectKey, String newRepoName) {
        JSONObject newRepoBodyObject = RepositoryTestHelper.createRepositoryBody(newRepoName);
        if (!newProjectKey.equals(originalProjectKey)) {
            JSONObject project = new JSONObject();
            project.put((Object)"key", (Object)newProjectKey);
            newRepoBodyObject.put((Object)"project", (Object)project);
        }
        String url = DefaultFuncTestData.getRestURL() + "/projects/" + originalProjectKey + "/repos/" + originalRepoSlug;
        return (Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).body(newRepoBodyObject.toString()).contentType("application/json").expect().log().ifError().statusCode(Response.Status.CREATED.getStatusCode()).when().put(url, new Object[0]);
    }

    private static String appendIndex(String content, int i, int count) {
        if (count == 1) {
            return content;
        }
        return content + '_' + i;
    }

    private static File createTempRepoFolder(String project, String repository) throws IOException {
        TemporaryFolder temporaryFolder = new TemporaryFolder();
        temporaryFolder.create();
        File repDir = new File(temporaryFolder.newFolder(project), repository);
        if (!repDir.mkdirs()) {
            throw new IOException("Failed to create directory for repository: " + repDir.getAbsolutePath());
        }
        return repDir;
    }

    private static URI getAuthenticatedURI(String user, String password, URI uri) throws URISyntaxException {
        return new URI(uri.getScheme(), user + ":" + password, uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
    }
}

