/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.test;

import com.atlassian.stash.test.DefaultFuncTestData;
import com.atlassian.stash.test.ResponsePage;
import com.atlassian.stash.test.RestTestHelper;
import com.google.common.collect.Lists;
import com.jayway.restassured.RestAssured;
import com.jayway.restassured.response.Response;
import java.util.Collection;
import java.util.List;
import net.sf.json.JSONObject;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.rules.ExternalResource;

@Deprecated
public class RestrictedRefTestHelper
extends ExternalResource {
    private final String project;
    private final String repo;
    private List<Integer> createdRestrictedRefs = Lists.newArrayList();

    public RestrictedRefTestHelper(String project, String repo) {
        this.project = project;
        this.repo = repo;
    }

    protected void after() {
        for (Integer id : this.createdRestrictedRefs) {
            this.deleteRestrictedRef(id, null);
        }
    }

    public void deleteAll() {
        for (JSONObject ref : this.getAll().getValues()) {
            this.deleteRestrictedRef(ref.getInt("id"), null);
        }
    }

    public ResponsePage<JSONObject> getAll() {
        return new ResponsePage<JSONObject>(((Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").when().get(RestrictedRefTestHelper.baseRestrictedRefUrl(this.project, this.repo), new Object[0])).body().jsonPath(), RestTestHelper.JSON_TRANSFORM);
    }

    public void deleteRestrictedRef(int restrictedRefId, Integer expectedResponseCode) {
        this.deleteRestrictedRef(restrictedRefId, expectedResponseCode, DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword());
    }

    public void deleteRestrictedRef(int restrictedRefId, Integer expectedResponseCode, String username, String password) {
        Matcher httpCodeMatcher = expectedResponseCode != null ? Matchers.equalTo((Object)expectedResponseCode) : Matchers.any(Integer.class);
        RestAssured.expect().statusCode(httpCodeMatcher).given().auth().preemptive().basic(username, password).contentType("application/json").when().delete(RestrictedRefTestHelper.baseRestrictedRefUrl(this.project, this.repo) + "/" + restrictedRefId, new Object[0]);
    }

    public Integer createRestrictedRef(Type type, String value, Collection<String> users, Collection<String> groups) {
        return this.createRestrictedRef(type, value, users, groups, DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword());
    }

    public Integer createRestrictedRef(Type type, String value, Collection<String> users, Collection<String> groups, String username, String password) {
        IdMatcher idMatcher = new IdMatcher();
        RestAssured.expect().statusCode(200).body("id", (Matcher)idMatcher, new Object[0]).given().auth().preemptive().basic(username, password).body(RestrictedRefTestHelper.restrictedRefRequestBody(null, type, value, users, groups).toString()).contentType("application/json").when().post(RestrictedRefTestHelper.baseRestrictedRefUrl(this.project, this.repo), new Object[0]);
        this.createdRestrictedRefs.add(idMatcher.getId());
        this.assertRestrictedRefValues(idMatcher.getId(), type, value);
        return idMatcher.getId();
    }

    public void updateRestrictedRef(int id, Type type, String value, Collection<String> users, Collection<String> groups) {
        this.updateRestrictedRef(id, type, value, users, groups, DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword());
    }

    public void updateRestrictedRef(int id, Type type, String value, Collection<String> users, Collection<String> groups, String username, String password) {
        RestAssured.expect().statusCode(200).body("id", Matchers.equalTo((Object)id), new Object[0]).given().auth().preemptive().basic(username, password).body(RestrictedRefTestHelper.restrictedRefRequestBody(id, type, value, users, groups).toString()).contentType("application/json").when().put(RestrictedRefTestHelper.baseRestrictedRefUrl(this.project, this.repo) + "/" + id, new Object[0]);
        this.assertRestrictedRefValues(id, type, value);
    }

    public void updateRestrictedRefExpectingUnauthorized(int id, Type type, String value, Collection<String> users, Collection<String> groups, String username, String password) {
        this.updateRestrictedRefExpectingCode(id, type, value, users, groups, username, password, 401);
    }

    public void updateRestrictedRefExpectingNotFound(int id, Type type, String value, Collection<String> users, Collection<String> groups) {
        this.updateRestrictedRefExpectingCode(id, type, value, users, groups, DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword(), 404);
    }

    public void updateRestrictedRefExpectingCode(int id, Type type, String value, Collection<String> users, Collection<String> groups, String username, String password, int code) {
        RestAssured.expect().statusCode(code).given().auth().preemptive().basic(username, password).body(RestrictedRefTestHelper.restrictedRefRequestBody(id, type, value, users, groups).toString()).contentType("application/json").when().put(RestrictedRefTestHelper.baseRestrictedRefUrl(this.project, this.repo) + "/" + id, new Object[0]);
    }

    public Response createRestrictedRefExpectingBadRequest(Type type, String value, Collection<String> users, Collection<String> groups) {
        return this.createRestrictedRefExpectingHttpCode(type, value, users, groups, DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword(), 400);
    }

    public Response createRestrictedRefExpectingConflict(Type type, String value, Collection<String> users, Collection<String> groups) {
        return this.createRestrictedRefExpectingHttpCode(type, value, users, groups, DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword(), 409);
    }

    public Response createRestrictedRefExpectingUnauthorized(Type type, String value, Collection<String> users, Collection<String> groups, String username, String password) {
        return this.createRestrictedRefExpectingHttpCode(type, value, users, groups, username, password, 401);
    }

    public Response createRestrictedRefExpectingHttpCode(Type type, String value, Collection<String> users, Collection<String> groups, String username, String password, int httpCode) {
        return (Response)RestAssured.expect().statusCode(httpCode).given().auth().preemptive().basic(username, password).body(RestrictedRefTestHelper.restrictedRefRequestBody(null, type, value, users, groups).toString()).contentType("application/json").when().post(RestrictedRefTestHelper.baseRestrictedRefUrl(this.project, this.repo), new Object[0]);
    }

    private void assertRestrictedRefValues(Integer id, Type type, String value) {
        RestAssured.expect().statusCode(200).body("id", Matchers.equalTo((Object)id), new Object[0]).body("type", Matchers.equalTo((Object)type.name()), new Object[0]).body("value", Matchers.equalTo((Object)value), new Object[0]).given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").when().get(RestrictedRefTestHelper.baseRestrictedRefUrl(this.project, this.repo) + "/" + id, new Object[0]);
    }

    private static String baseRestrictedRefUrl(String projectKey, String repositorySlug) {
        return DefaultFuncTestData.getRestURL("branch-permissions", "1.0") + "/projects/" + projectKey + "/repos/" + repositorySlug + "/restricted";
    }

    private static JSONObject restrictedRefRequestBody(Integer id, Type type, String value, Collection<String> users, Collection<String> groups) {
        JSONObject obj = new JSONObject();
        obj.put((Object)"id", (Object)id);
        obj.put((Object)"type", (Object)(type == null ? null : type.name()));
        obj.put((Object)"value", (Object)value);
        obj.put((Object)"users", users);
        obj.put((Object)"groups", groups);
        return obj;
    }

    private static class IdMatcher
    extends BaseMatcher<Object> {
        private Integer id;

        private IdMatcher() {
        }

        public Integer getId() {
            return this.id;
        }

        public boolean matches(Object o) {
            if (o instanceof Number) {
                this.id = ((Number)o).intValue();
                return true;
            }
            return false;
        }

        public void describeTo(Description description) {
            Matchers.any(Number.class).describeTo(description);
        }
    }

    public static enum Type {
        BRANCH,
        PATTERN;

    }
}

