/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.test;

import com.atlassian.fugue.Option;
import com.atlassian.stash.test.ProductTopology;
import com.atlassian.stash.test.ProductTopologyAdapter;
import com.google.common.base.Supplier;
import javax.annotation.Nonnull;

public class StashTestLicense {
    private final Option<String> clusteredLicense;
    private final Option<String> standaloneLicense;

    private StashTestLicense(Option<String> clusteredLicense, Option<String> nonClusteredLicense) {
        this.clusteredLicense = clusteredLicense;
        this.standaloneLicense = nonClusteredLicense;
    }

    public String get() {
        return ProductTopology.get().accept(new ProductTopologyAdapter<String>(){

            @Override
            public String visitDefault() {
                return StashTestLicense.this.getNonClusteredVersion();
            }

            @Override
            public String visitStashClusterPair() {
                return StashTestLicense.this.getClusteredVersion();
            }
        });
    }

    public String getClusteredVersion() {
        return (String)this.clusteredLicense.getOrThrow((Supplier)new Supplier<IllegalStateException>(){

            public IllegalStateException get() {
                return new IllegalStateException("A clustered license is required for this operation but one has not been supplied");
            }
        });
    }

    public String getNonClusteredVersion() {
        return (String)this.standaloneLicense.getOrThrow((Supplier)new Supplier<IllegalStateException>(){

            public IllegalStateException get() {
                return new IllegalStateException("A standalone license is required for this operation but one has not been supplied");
            }
        });
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Option<String> clusteredLicense;
        private Option<String> standaloneLicense;

        public Builder whenClustered(@Nonnull String license) {
            this.clusteredLicense = Option.some((Object)license);
            return this;
        }

        public Builder whenNonClustered(@Nonnull String license) {
            this.standaloneLicense = Option.some((Object)license);
            return this;
        }

        public StashTestLicense build() {
            return new StashTestLicense(this.clusteredLicense, this.standaloneLicense);
        }
    }
}

