/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.test;

import com.atlassian.fugue.Option;
import com.atlassian.stash.mail.MailHostConfiguration;
import com.atlassian.stash.project.Project;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.rest.data.RestProject;
import com.atlassian.stash.test.BranchTestHelper;
import com.atlassian.stash.test.DefaultFuncTestData;
import com.atlassian.stash.test.GroupTestHelper;
import com.atlassian.stash.test.MailServerConfigHelper;
import com.atlassian.stash.test.PermissionsTestHelper;
import com.atlassian.stash.test.ProcessTestHelper;
import com.atlassian.stash.test.ProjectTestHelper;
import com.atlassian.stash.test.PullRequestTestHelper;
import com.atlassian.stash.test.RepositoryTestHelper;
import com.atlassian.stash.test.SshAccessKeysTestHelper;
import com.atlassian.stash.test.SshKeyTestHelper;
import com.atlassian.stash.test.TaskTestHelper;
import com.atlassian.stash.test.ThrowableUtils;
import com.atlassian.stash.test.UserTestHelper;
import com.atlassian.stash.test.rest.RestProjects;
import com.atlassian.stash.user.Permission;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.jayway.restassured.RestAssured;
import com.jayway.restassured.response.Response;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.ws.rs.core.Response;
import net.sf.json.JSONObject;
import org.codehaus.jackson.map.ObjectMapper;
import org.junit.Assert;
import org.junit.rules.ExternalResource;
import org.junit.rules.TemporaryFolder;
import org.junit.runners.model.MultipleFailureException;
import org.springframework.core.io.Resource;
import org.springframework.util.ObjectUtils;

public class TestContext
extends ExternalResource
implements AutoCloseable {
    public static final String DEFAULT_EMAIL_HOST = "@testdata.atlassian.com";
    private static final List<String> FEATURE_DISCOVERY_KEYS = Arrays.asList("sidebar", "side-by-side-diff-discovery", "jira-pull-request");
    private final Set<CreatedAccessKey> accessKeys = new HashSet<CreatedAccessKey>();
    private final Set<Integer> accountKeys = new HashSet<Integer>();
    private final Set<CreatedBranch> createdBranches = new HashSet<CreatedBranch>();
    private final Set<CreatedRepository> createdForks = new HashSet<CreatedRepository>();
    private final Set<String> createdGroups = new HashSet<String>();
    private final Set<String> createdProjects = new HashSet<String>();
    private final Set<PullRequestTestHelper> createdPullRequests = new HashSet<PullRequestTestHelper>();
    private final Set<CreatedRepository> createdRepositories = new HashSet<CreatedRepository>();
    private final Set<TaskTestHelper> createdTasks = new HashSet<TaskTestHelper>();
    private final Set<String> createdUsers = new HashSet<String>();
    private final List<Throwable> errors = new ArrayList<Throwable>();
    private final Set<GrantedPermission> grantedPermissions = new HashSet<GrantedPermission>();
    private Option<MailHostConfiguration> origMailHostConfiguration;
    private Option<String> origSenderAddress;

    protected void after() {
        try {
            this.cleanup();
        }
        catch (Throwable throwable) {
            throw Throwables.propagate((Throwable)throwable);
        }
    }

    public TestContext accessKey(String projKey, Permission permission, String publicKey) {
        return this.accessKey(projKey, null, permission, publicKey);
    }

    public TestContext accessKey(final String projKey, final String repoSlug, final Permission permission, final String publicKey) {
        return this.ensureCleanup(new Callable<TestContext>(){

            @Override
            public TestContext call() throws Exception {
                Response response = repoSlug != null ? SshAccessKeysTestHelper.add(projKey, repoSlug, permission, publicKey) : SshAccessKeysTestHelper.add(projKey, permission, publicKey);
                Map keyMap = response.getBody().jsonPath().getMap("key");
                if (keyMap != null) {
                    Integer keyId = (Integer)keyMap.get("id");
                    TestContext.this.accessKeys.add(new CreatedAccessKey(keyId, projKey, repoSlug));
                }
                return TestContext.this;
            }
        });
    }

    public TestContext accountKey(final String username, final String keyText) {
        return this.ensureCleanup(new Callable<TestContext>(){

            @Override
            public TestContext call() throws Exception {
                Response response = SshKeyTestHelper.addSshKey(username, keyText);
                Map keyMap = response.getBody().jsonPath().getMap("");
                if (keyMap != null) {
                    TestContext.this.accountKeys.add((Integer)keyMap.get("id"));
                }
                return TestContext.this;
            }
        });
    }

    public TestContext addCreatedBranch(String projectKey, String repoSlug, String branchName) {
        this.createdBranches.add(new CreatedBranch(projectKey, repoSlug, branchName));
        return this;
    }

    public void addCreatedGroup(String group) {
        this.createdGroups.add(group);
    }

    public void addCreatedUser(String username) {
        this.createdUsers.add(username);
    }

    public TestContext branch(final String projectKey, final String repoSlug, final String branchName, final String branchFrom) {
        return this.ensureCleanup(new Callable<TestContext>(){

            @Override
            public TestContext call() throws Exception {
                BranchTestHelper.createBranch(projectKey, repoSlug, branchName, branchFrom);
                return TestContext.this.addCreatedBranch(projectKey, repoSlug, branchName);
            }
        });
    }

    public void cleanup() throws Throwable {
        this.cleanupAccountKeys();
        this.cleanupAccessKeys();
        this.cleanupPullRequests();
        this.cleanupBranches();
        this.cleanupRepositories();
        this.cleanupProjects();
        this.cleanupPermissions();
        this.cleanupUsers();
        this.cleanupGroups();
        this.cleanupTasks();
        this.cleanupMailConfig();
        MultipleFailureException.assertEmpty(this.errors);
    }

    public TestContext mailConfig(MailHostConfiguration configuration, String senderAddress) {
        if (this.origMailHostConfiguration == null) {
            this.origMailHostConfiguration = Option.option((Object)MailServerConfigHelper.getMailHostConfiguration());
        }
        if (this.origSenderAddress == null) {
            this.origSenderAddress = Option.option((Object)MailServerConfigHelper.getSenderAddress());
        }
        MailServerConfigHelper.setConfig(configuration, senderAddress);
        return this;
    }

    public TestContext serverEmailAddress(String senderAddress) {
        if (this.origSenderAddress == null) {
            this.origSenderAddress = Option.option((Object)MailServerConfigHelper.getSenderAddress());
        }
        MailServerConfigHelper.setSenderAddress(senderAddress);
        return this;
    }

    public TestContext project(String projectKey) {
        return this.project(projectKey, projectKey, "Project description for " + projectKey);
    }

    public TestContext project(String projectKey, String projectName) {
        return this.project(projectKey, projectName, "Project description for " + projectName);
    }

    public TestContext project(final String projectKey, final String projectName, final String projectDescription) {
        return this.ensureCleanup(new Callable<TestContext>(){

            @Override
            public TestContext call() {
                ProjectTestHelper.createProject(projectKey, projectName, projectDescription);
                TestContext.this.createdProjects.add(projectKey);
                return TestContext.this;
            }
        });
    }

    public TestContext project(final String projectKey, final String projectName, final String projectDescription, final String projectAvatar) {
        return this.ensureCleanup(new Callable<TestContext>(){

            @Override
            public TestContext call() {
                ProjectTestHelper.createProject(projectKey, projectName, projectDescription, projectAvatar);
                TestContext.this.createdProjects.add(projectKey);
                return TestContext.this;
            }
        });
    }

    public TestContext projects(String projectKeyFormat, String projectNameFormat, int projectCount) {
        return this.projects(projectKeyFormat, projectNameFormat, "Project description for %s", projectCount);
    }

    public TestContext projects(final String projectKeyFormat, final String projectNameFormat, final String projectDescriptionFormat, final int projectCount) {
        return this.ensureCleanup(new Callable<TestContext>(){

            @Override
            public TestContext call() {
                Response response = ProjectTestHelper.createProjects(projectKeyFormat, projectNameFormat, projectDescriptionFormat, projectCount);
                try {
                    RestProjects projects = (RestProjects)((Object)new ObjectMapper().readValue(response.body().print(), RestProjects.class));
                    for (RestProject project : projects.getProjects()) {
                        TestContext.this.createdProjects.add(project.getKey());
                    }
                }
                catch (Exception e) {
                    return TestContext.this;
                }
                return TestContext.this;
            }
        });
    }

    public TestContext repository(String projectKey, String repositoryKey) {
        return this.repository(projectKey, repositoryKey, false);
    }

    public TestContext repository(final String projectKey, final String repositoryName, final boolean publiclyAccessible) {
        return this.ensureCleanup(new Callable<TestContext>(){

            @Override
            public TestContext call() {
                TestContext.this.doCreateRepository(projectKey, repositoryName, publiclyAccessible);
                return TestContext.this;
            }
        });
    }

    public TestContext repository(String projectKey, String repositoryName, Resource repoZip) throws IOException {
        return this.repository(projectKey, repositoryName, repoZip, (Function<? super ProcessTestHelper, Object>)Functions.constant(null));
    }

    public TestContext repository(String projectKey, String repositoryName, Resource repoZip, boolean publiclyAccessible) throws IOException {
        return this.repository(projectKey, repositoryName, repoZip, (Function<? super ProcessTestHelper, Object>)Functions.constant(null), publiclyAccessible);
    }

    public TestContext repository(String projectKey, String repositoryName, Resource repoZip, Function<? super ProcessTestHelper, Object> callback) throws IOException {
        return this.repository(projectKey, repositoryName, repoZip, callback, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TestContext repository(final String projectKey, String repositoryName, final Resource repoZip, final Function<? super ProcessTestHelper, Object> callback, boolean publiclyAccessible) throws IOException {
        final CreatedRepository created = this.doCreateRepository(projectKey, repositoryName, publiclyAccessible);
        final TemporaryFolder temporaryFolder = new TemporaryFolder();
        temporaryFolder.create();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        try {
            TestContext testContext = this.ensureCleanup(new Callable<TestContext>(){

                @Override
                public TestContext call() {
                    try {
                        RepositoryTestHelper.pushRep(temporaryFolder, DefaultFuncTestData.getBaseURL(), DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword(), projectKey, created.slug, repoZip, (Function<? super ProcessTestHelper, Object>)callback);
                        return TestContext.this;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            return testContext;
        }
        finally {
            temporaryFolder.delete();
        }
    }

    public TestContext fork(final String projectKey, final String repoKey, final String username, final String password) {
        return this.ensureCleanup(new Callable<TestContext>(){

            @Override
            public TestContext call() {
                RepositoryTestHelper.forkRepositoryAndWait(projectKey, repoKey, username, password, 2500L);
                TestContext.this.createdForks.add(new CreatedRepository("~" + username, repoKey));
                return TestContext.this;
            }
        });
    }

    public TestContext forkNonPersonal(final String projectKey, final String repoKey, final String destProjectKey, final String destRepoKey) {
        return this.ensureCleanup(new Callable<TestContext>(){

            @Override
            public TestContext call() {
                RepositoryTestHelper.forkNonPersonalRepositoryAndWait(projectKey, repoKey, destProjectKey, destRepoKey, 2500L);
                TestContext.this.createdForks.add(new CreatedRepository(destProjectKey, destRepoKey));
                return TestContext.this;
            }
        });
    }

    public TestContext group(final String group, final String ... users) {
        return this.ensureCleanup(new Callable<TestContext>(){

            @Override
            public TestContext call() {
                GroupTestHelper.createGroups(group);
                for (String user : users) {
                    GroupTestHelper.addUserToGroup(group, user);
                }
                TestContext.this.addCreatedGroup(group);
                return TestContext.this;
            }
        });
    }

    public TestContext user(String username) {
        return this.user(username, username, username, username + DEFAULT_EMAIL_HOST);
    }

    public TestContext user(String username, boolean addToDefaultGroup) {
        return this.user(username, username, username, username + DEFAULT_EMAIL_HOST, addToDefaultGroup);
    }

    public TestContext user(String username, String password) {
        return this.user(username, username, password, username + DEFAULT_EMAIL_HOST);
    }

    public TestContext user(String username, String displayName, String password) {
        return this.user(username, displayName, password, username + DEFAULT_EMAIL_HOST);
    }

    public TestContext user(String username, String displayName, String password, String emailAddress) {
        return this.user(username, displayName, password, emailAddress, true);
    }

    public TestContext user(final String username, final String displayName, final String password, final String emailAddress, final boolean addToDefaultGroup) {
        return this.ensureCleanup(new Callable<TestContext>(){

            @Override
            public TestContext call() {
                UserTestHelper.createUser(username, displayName, password, emailAddress, addToDefaultGroup);
                TestContext.this.addCreatedUser(username);
                return TestContext.this;
            }
        });
    }

    public TestContext globalPermission(final String username, final Permission permission) {
        Preconditions.checkArgument((boolean)permission.isGlobal());
        return this.ensureCleanup(new Callable<TestContext>(){

            @Override
            public TestContext call() {
                PermissionsTestHelper.setGlobalPermissionForUser(username, permission.name());
                TestContext.this.grantedPermissions.add(new GrantedPermission(GrantedPermission.EntityType.USER, username, permission, null, null));
                return TestContext.this;
            }
        });
    }

    public TestContext globalPermissionForGroup(final String group, final Permission permission) {
        Preconditions.checkArgument((boolean)permission.isGlobal());
        return this.ensureCleanup(new Callable<TestContext>(){

            @Override
            public TestContext call() {
                PermissionsTestHelper.setGlobalPermissionForGroup(group, permission.name());
                TestContext.this.grantedPermissions.add(new GrantedPermission(GrantedPermission.EntityType.GROUP, group, permission, null, null));
                return TestContext.this;
            }
        });
    }

    public TestContext projectPermission(final String projectKey, final String username, final Permission permission) {
        Preconditions.checkArgument((boolean)permission.isResource(Project.class));
        return this.ensureCleanup(new Callable<TestContext>(){

            @Override
            public TestContext call() {
                PermissionsTestHelper.setProjectPermissionForUser(projectKey, username, permission.name());
                TestContext.this.grantedPermissions.add(new GrantedPermission(GrantedPermission.EntityType.USER, username, permission, projectKey, null));
                return TestContext.this;
            }
        });
    }

    public TestContext repositoryPermission(final String projectKey, final String repoSlug, final String username, final Permission permission) {
        Preconditions.checkArgument((boolean)permission.isResource(Repository.class));
        return this.ensureCleanup(new Callable<TestContext>(){

            @Override
            public TestContext call() {
                PermissionsTestHelper.setRepositoryPermissionForUser(projectKey, repoSlug, username, permission.name());
                TestContext.this.grantedPermissions.add(new GrantedPermission(GrantedPermission.EntityType.USER, username, permission, projectKey, repoSlug));
                return TestContext.this;
            }
        });
    }

    public TestContext repositoryPermissionForGroup(final String projectKey, final String repoSlug, final String group, final Permission permission) {
        Preconditions.checkArgument((boolean)permission.isResource(Repository.class));
        return this.ensureCleanup(new Callable<TestContext>(){

            @Override
            public TestContext call() {
                PermissionsTestHelper.setRepositoryPermissionForGroup(projectKey, repoSlug, group, permission.name());
                TestContext.this.grantedPermissions.add(new GrantedPermission(GrantedPermission.EntityType.GROUP, group, permission, projectKey, repoSlug));
                return TestContext.this;
            }
        });
    }

    public TestContext noFeatureDiscovery(String username, String password) {
        for (String featureKey : FEATURE_DISCOVERY_KEYS) {
            RestAssured.given().auth().preemptive().basic(username, password).formParam("json", new Object[]{"{\"isAllDismissed\": true}"}).expect().statusCode(Response.Status.OK.getStatusCode()).when().post(DefaultFuncTestData.getRestURL("chaperone", "1") + "/chaperone/" + featureKey, new Object[0]);
        }
        return this;
    }

    public PullRequestTestHelper pullRequest(final PullRequestTestHelper.Builder pullRequestBuilder) {
        return this.ensureCleanup(new Callable<PullRequestTestHelper>(){

            @Override
            public PullRequestTestHelper call() {
                PullRequestTestHelper pullRequest = pullRequestBuilder.create();
                TestContext.this.createdPullRequests.add(pullRequest);
                return pullRequest;
            }
        });
    }

    public TaskTestHelper task(final TaskTestHelper.Builder taskBuilder) {
        return this.ensureCleanup(new Callable<TaskTestHelper>(){

            @Override
            public TaskTestHelper call() {
                TaskTestHelper task = taskBuilder.create();
                TestContext.this.createdTasks.add(task);
                return task;
            }
        });
    }

    private <T> T ensureCleanup(Callable<T> work) {
        try {
            return work.call();
        }
        catch (Throwable t) {
            try {
                this.cleanup();
            }
            catch (Throwable t2) {
                ThrowableUtils.throwUnchecked((Throwable)new MultipleFailureException(Arrays.asList(t, new Exception("An exception occurred while attempting to clean up", t2))));
            }
            ThrowableUtils.throwUnchecked(t);
            return null;
        }
    }

    private void cleanupAccountKeys() {
        for (Integer keyId : this.accountKeys) {
            try {
                SshKeyTestHelper.removeSshKey(keyId);
            }
            catch (Throwable t) {
                this.errors.add(new TestContextCleanupException("Failed to clean up account key " + keyId, t));
            }
        }
        this.accountKeys.clear();
    }

    private void cleanupAccessKeys() {
        for (CreatedAccessKey accessKey : this.accessKeys) {
            try {
                accessKey.revoke();
            }
            catch (Throwable t) {
                this.errors.add(new TestContextCleanupException("Failed to clean up access key " + accessKey, t));
            }
        }
        this.accessKeys.clear();
    }

    private void cleanupBranches() {
        for (CreatedBranch branch : this.createdBranches) {
            try {
                BranchTestHelper.deleteBranch(branch.projectKey, branch.repoSlug, branch.branchName);
            }
            catch (Throwable t) {
                this.errors.add(new TestContextCleanupException("Failed to clean up branch " + branch, t));
            }
        }
        this.createdBranches.clear();
    }

    private void cleanupMailConfig() {
        if (this.origMailHostConfiguration != null) {
            try {
                if (this.origMailHostConfiguration.isEmpty()) {
                    MailServerConfigHelper.deleteConfig();
                } else {
                    MailServerConfigHelper.setConfig((MailHostConfiguration)this.origMailHostConfiguration.get());
                    this.origMailHostConfiguration = null;
                }
            }
            catch (Throwable t) {
                this.errors.add(new TestContextCleanupException("Failed to clear mail host configuration", t));
            }
        }
        if (this.origSenderAddress != null) {
            try {
                if (this.origSenderAddress.isEmpty()) {
                    MailServerConfigHelper.clearSenderAddress();
                } else {
                    MailServerConfigHelper.setSenderAddress((String)this.origSenderAddress.get());
                    this.origSenderAddress = null;
                }
            }
            catch (Throwable t) {
                this.errors.add(new TestContextCleanupException("Failed to clear server email address", t));
            }
        }
    }

    private void cleanupPermissions() {
        for (GrantedPermission permission : this.grantedPermissions) {
            try {
                permission.revoke();
            }
            catch (Throwable t) {
                this.errors.add(new TestContextCleanupException("Failed to revoke permission " + permission, t));
            }
        }
        this.grantedPermissions.clear();
    }

    private void cleanupUsers() {
        for (String username : this.createdUsers) {
            try {
                UserTestHelper.deleteUsers(true, username);
            }
            catch (Throwable t) {
                this.errors.add(new TestContextCleanupException("Failed to delete user " + username, t));
            }
        }
        this.createdUsers.clear();
    }

    private void cleanupGroups() {
        for (String group : this.createdGroups) {
            try {
                GroupTestHelper.deleteGroups(true, group);
            }
            catch (Throwable t) {
                this.errors.add(new TestContextCleanupException("Failed to delete group " + group, t));
            }
        }
        this.createdGroups.clear();
    }

    private void cleanupRepositories() {
        for (CreatedRepository fork : this.createdForks) {
            this.cleanupRepo(fork);
        }
        this.createdForks.clear();
        for (CreatedRepository createdRepository : this.createdRepositories) {
            this.cleanupRepo(createdRepository);
        }
        this.createdRepositories.clear();
    }

    private void cleanupRepo(CreatedRepository createdRepository) {
        try {
            Assert.assertTrue((String)("Repository " + createdRepository.projectKey + "/" + createdRepository.slug + " was not deleted"), (boolean)RepositoryTestHelper.deleteRepositoryAndWait(createdRepository.projectKey, createdRepository.slug, 1000L));
        }
        catch (Throwable t) {
            this.errors.add(new TestContextCleanupException("Failed to delete repository " + createdRepository, t));
        }
    }

    private void cleanupProjects() {
        for (String projectKey : this.createdProjects) {
            try {
                Response response = ProjectTestHelper.deleteProject(projectKey);
                Assert.assertTrue((String)("Project " + projectKey + " was not deleted"), (response.getStatusCode() == Response.Status.NO_CONTENT.getStatusCode() || response.getStatusCode() == Response.Status.NOT_FOUND.getStatusCode() ? 1 : 0) != 0);
            }
            catch (Throwable t) {
                this.errors.add(new TestContextCleanupException("Failed to delete project " + projectKey, t));
            }
        }
        this.createdProjects.clear();
    }

    private void cleanupPullRequests() {
        for (PullRequestTestHelper pullRequest : this.createdPullRequests) {
            try {
                pullRequest.declineSafe();
            }
            catch (Throwable t) {
                this.errors.add(new TestContextCleanupException("Failed to cleanup pull request " + pullRequest, t));
            }
        }
        this.createdPullRequests.clear();
    }

    private void cleanupTasks() {
        for (TaskTestHelper task : this.createdTasks) {
            try {
                task.deleteSafe();
            }
            catch (Throwable t) {
                this.errors.add(new TestContextCleanupException("Failed to delete task " + task, t));
            }
        }
        this.createdTasks.clear();
    }

    private CreatedRepository doCreateRepository(String projectKey, String repositoryName, boolean publiclyAccessible) {
        JSONObject repositoryBody = RepositoryTestHelper.createRepositoryBody(repositoryName);
        repositoryBody.put((Object)"public", (Object)publiclyAccessible);
        String slug = RepositoryTestHelper.getSlugFromResponse(RepositoryTestHelper.createRepositoryAndWait(projectKey, repositoryName, 2500L, repositoryBody));
        CreatedRepository result = new CreatedRepository(projectKey, slug);
        this.createdRepositories.add(result);
        return result;
    }

    @Override
    public void close() throws Exception {
        try {
            this.cleanup();
        }
        catch (Throwable throwable) {
            Throwables.propagate((Throwable)throwable);
        }
    }

    public static <A> A perform(Function<TestContext, A> f) throws Exception {
        try (TestContext context = new TestContext();){
            Object object = f.apply((Object)context);
            return (A)object;
        }
    }

    private static class TestContextCleanupException
    extends Exception {
        public TestContextCleanupException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    private static class CreatedRepository {
        public String projectKey;
        public String slug;

        public CreatedRepository(String projectKey, String slug) {
            this.projectKey = projectKey;
            this.slug = slug;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof CreatedRepository) {
                CreatedRepository r = (CreatedRepository)o;
                return ObjectUtils.nullSafeEquals((Object)this.projectKey, (Object)r.projectKey) && ObjectUtils.nullSafeEquals((Object)this.slug, (Object)r.slug);
            }
            return false;
        }

        public int hashCode() {
            return ObjectUtils.nullSafeHashCode((Object[])new Object[]{this.projectKey, this.slug});
        }

        public String toString() {
            return "{projectKey: " + this.projectKey + ", repoSlug:" + this.slug + "}";
        }
    }

    private static class GrantedPermission {
        public final Permission permission;
        public final String projectKey;
        public final String repoSlug;
        public final String entity;
        public final EntityType entityType;

        public GrantedPermission(EntityType entityType, String entity, Permission permission, String projectKey, String repoSlug) {
            this.entityType = entityType;
            this.entity = entity;
            this.permission = permission;
            this.projectKey = projectKey;
            this.repoSlug = repoSlug;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void revoke() {
            if (this.entityType == EntityType.USER) {
                if (this.permission.isGlobal()) {
                    PermissionsTestHelper.revokeGlobalPermissionsForUser(this.entity);
                    return;
                } else if (this.permission.isResource(Project.class)) {
                    PermissionsTestHelper.revokeProjectPermissionForUser(this.projectKey, this.entity);
                    return;
                } else {
                    if (!this.permission.isResource(Repository.class)) throw new IllegalStateException("Unknown permission: " + this.permission.name());
                    PermissionsTestHelper.revokeRepositoryPermissionForUser(this.projectKey, this.repoSlug, this.entity);
                }
                return;
            } else if (this.permission.isGlobal()) {
                PermissionsTestHelper.revokeGlobalPermissionsForGroup(this.entity);
                return;
            } else if (this.permission.isResource(Project.class)) {
                PermissionsTestHelper.revokeProjectPermissionForGroup(this.projectKey, this.entity);
                return;
            } else {
                if (!this.permission.isResource(Repository.class)) throw new IllegalStateException("Unknown permission: " + this.permission.name());
                PermissionsTestHelper.revokeRepositoryPermissionForGroup(this.projectKey, this.repoSlug, this.entity);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof GrantedPermission) {
                GrantedPermission gp = (GrantedPermission)o;
                return ObjectUtils.nullSafeEquals((Object)((Object)this.entityType), (Object)((Object)gp.entityType)) && ObjectUtils.nullSafeEquals((Object)this.entity, (Object)gp.entity) && ObjectUtils.nullSafeEquals((Object)this.projectKey, (Object)gp.projectKey) && ObjectUtils.nullSafeEquals((Object)this.repoSlug, (Object)gp.repoSlug) && ObjectUtils.nullSafeEquals((Object)this.permission, (Object)gp.permission);
            }
            return false;
        }

        public int hashCode() {
            return ObjectUtils.nullSafeHashCode((Object[])new Object[]{this.entityType, this.entity, this.projectKey, this.repoSlug, this.permission});
        }

        public String toString() {
            return "{projectKey: " + this.projectKey + ", repoSlug:" + this.repoSlug + ", permission: " + this.permission + ", entityType: " + (Object)((Object)this.entityType) + ", entity: " + this.entity + "}";
        }

        public static enum EntityType {
            USER,
            GROUP;

        }
    }

    private static class CreatedBranch {
        public final String projectKey;
        public final String repoSlug;
        public final String branchName;

        private CreatedBranch(String projectKey, String repoSlug, String branchName) {
            this.projectKey = projectKey;
            this.repoSlug = repoSlug;
            this.branchName = branchName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof CreatedBranch) {
                CreatedBranch b = (CreatedBranch)o;
                return Objects.equals(this.projectKey, b.projectKey) && Objects.equals(this.repoSlug, b.repoSlug) && Objects.equals(this.branchName, b.branchName);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.projectKey, this.repoSlug, this.branchName);
        }

        public String toString() {
            return "{projectKey: " + this.projectKey + ", repoSlug:" + this.repoSlug + ", branchName: " + this.branchName + "}";
        }
    }

    private static class CreatedAccessKey {
        public final Integer keyId;
        public final String projectKey;
        public final String repoSlug;

        public CreatedAccessKey(Integer keyId, String projectKey, String repoSlug) {
            this.keyId = keyId;
            this.projectKey = projectKey;
            this.repoSlug = repoSlug;
        }

        public void revoke() {
            if (this.repoSlug == null) {
                SshAccessKeysTestHelper.revoke(this.projectKey, this.keyId);
            } else {
                SshAccessKeysTestHelper.revoke(this.projectKey, this.repoSlug, this.keyId);
            }
        }

        public String toString() {
            return "{projectKey: " + this.projectKey + ", repoSlug:" + this.repoSlug + ", keyId: " + this.keyId + "}";
        }
    }
}

