/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.test.rest.commit;

import com.atlassian.stash.test.rest.RestPagedRequest;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class RestChangesRequest
extends RestPagedRequest {
    private final String since;
    private final Boolean withComments;

    private RestChangesRequest(Builder builder) {
        super(builder);
        this.since = builder.since;
        this.withComments = builder.withComments;
    }

    @Nullable
    public String getSince() {
        return this.since;
    }

    @Nullable
    public Boolean getWithComments() {
        return this.withComments;
    }

    @Override
    @Nonnull
    public Map<String, Object> toQueryParams() {
        Map<String, Object> params = super.toQueryParams();
        if (this.since != null) {
            params.put("since", this.since);
        }
        if (this.withComments != null) {
            params.put("withComments", this.withComments);
        }
        return params;
    }

    public static class Builder
    extends RestPagedRequest.AbstractPagedRequestBuilder<Builder, RestChangesRequest> {
        private String since;
        private Boolean withComments;

        public Builder() {
        }

        public Builder(@Nonnull RestChangesRequest request) {
            super(request);
        }

        @Override
        @Nonnull
        public RestChangesRequest build() {
            return new RestChangesRequest(this);
        }

        @Nonnull
        public Builder since(@Nullable String value) {
            this.since = StringUtils.trimToNull((String)value);
            return this.self();
        }

        @Nonnull
        public Builder withComments(@Nullable Boolean value) {
            this.withComments = value;
            return this.self();
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

