/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.test.rest.commit;

import com.atlassian.stash.test.DefaultFuncTestData;
import com.atlassian.stash.test.RestTestHelper;
import com.atlassian.stash.test.rest.AbstractRestHelper;
import com.atlassian.stash.test.rest.RestAuthentication;
import com.atlassian.stash.test.rest.comment.RestCommentRequest;
import com.atlassian.stash.test.rest.comment.RestCommentUtils;
import com.atlassian.stash.test.rest.commit.AbstractRestCommitCommentsRequest;
import com.atlassian.stash.test.rest.commit.RestAddCommitCommentRequest;
import com.atlassian.stash.test.rest.commit.RestChangesRequest;
import com.atlassian.stash.test.rest.commit.RestDeleteCommitCommentRequest;
import com.atlassian.stash.test.rest.commit.RestDiffRequest;
import com.atlassian.stash.test.rest.commit.RestGetCommitCommentRequest;
import com.atlassian.stash.test.rest.commit.RestGetCommitCommentsRequest;
import com.atlassian.stash.test.rest.commit.RestUpdateCommitCommentRequest;
import com.jayway.restassured.path.json.JsonPath;
import com.jayway.restassured.response.Response;
import javax.annotation.Nonnull;
import javax.ws.rs.core.Response;

public class RestCommitHelper
extends AbstractRestHelper {
    private final String commitId;
    private final String projectKey;
    private final String repositorySlug;

    public RestCommitHelper(String commitId) {
        this(DefaultFuncTestData.getAdminAuthentication(), DefaultFuncTestData.getProject1(), DefaultFuncTestData.getProject1Repository1(), commitId);
    }

    public RestCommitHelper(RestAuthentication authentication, String projectKey, String repositorySlug, String commitId) {
        super(authentication);
        this.projectKey = projectKey;
        this.repositorySlug = repositorySlug;
        this.commitId = commitId;
    }

    public JsonPath addComment(@Nonnull RestAddCommitCommentRequest request) {
        return this.post(this.getCommentsUrl(request), request);
    }

    public void deleteComment(@Nonnull RestDeleteCommitCommentRequest request) {
        this.delete(this.getCommentUrl(request), request);
    }

    public JsonPath get() {
        return ((Response)this.request().expect().statusCode(Response.Status.OK.getStatusCode()).log().ifError().get(this.getUrl(), new Object[0])).body().jsonPath();
    }

    public JsonPath getChanges(@Nonnull RestChangesRequest request) {
        return this.get(this.getChangesUrl(request), request);
    }

    public JsonPath getComment(@Nonnull RestGetCommitCommentRequest request) {
        return this.get(this.getCommentUrl(request), request);
    }

    public JsonPath getComments(@Nonnull RestGetCommitCommentsRequest request) {
        return this.get(this.getCommentsUrl(request), request);
    }

    public JsonPath getDiff(@Nonnull RestDiffRequest request) {
        return this.get(this.getDiffUrl(request), request);
    }

    public String getChangesUrl(@Nonnull RestChangesRequest request) {
        return RestTestHelper.buildUrl(RestCommitHelper.getChangesUrl(this.projectKey, this.repositorySlug, this.commitId), request);
    }

    public String getCommentsUrl(@Nonnull AbstractRestCommitCommentsRequest request) {
        return RestTestHelper.buildUrl(this.getCommentsUrl(), request);
    }

    public String getCommentUrl(@Nonnull RestCommentRequest request) {
        return RestTestHelper.buildUrl(this.getCommentsUrl() + "/" + request.getId(), request);
    }

    public String getDiffUrl(@Nonnull RestDiffRequest request) {
        return RestTestHelper.buildUrl(RestCommitHelper.getDiffUrl(this.projectKey, this.repositorySlug, this.commitId, request.getPath()), request);
    }

    public String getUrl() {
        return RestCommitHelper.getViewUrl(this.projectKey, this.repositorySlug, this.commitId);
    }

    public String getWatchUrl() {
        return RestCommitHelper.getWatchUrl(this.projectKey, this.repositorySlug, this.commitId);
    }

    public JsonPath updateComment(@Nonnull RestUpdateCommitCommentRequest request) {
        return this.put(this.getCommentUrl(request), request);
    }

    public static String getChangesUrl(String projectKey, String repositorySlug, String commitId) {
        return RestCommitHelper.getViewUrl(projectKey, repositorySlug, commitId) + "/changes";
    }

    public static String getDiffUrl(String projectKey, String repositorySlug, String commitId, String path) {
        return RestCommitHelper.getViewUrl(projectKey, repositorySlug, commitId) + "/diff/" + path;
    }

    public static String getListUrl(String projectKey, String repositorySlug) {
        return DefaultFuncTestData.getRestURL() + "/projects/" + projectKey + "/repos/" + repositorySlug + "/commits";
    }

    public static String getViewUrl(String projectKey, String repositorySlug, String id) {
        return RestCommitHelper.getListUrl(projectKey, repositorySlug) + "/" + id;
    }

    public static String getWatchUrl(String projectKey, String repositorySlug, String id) {
        return RestCommitHelper.getViewUrl(projectKey, repositorySlug, id) + "/watch";
    }

    private String getCommentsUrl() {
        return RestCommentUtils.getCommitDiscussionCommentsUrl(this.projectKey, this.repositorySlug, this.commitId);
    }
}

