/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.test.rest.repository.sync;

import com.atlassian.stash.test.rest.AbstractRestRequest;
import com.atlassian.stash.test.rest.HasBody;
import com.atlassian.stash.test.rest.repository.sync.RestRefSyncAction;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.sf.json.JSONObject;

public class RestSynchronizeRefRequest
extends AbstractRestRequest
implements HasBody {
    private final RestRefSyncAction action;
    private final JSONObject body;
    private final Map<String, Object> context;
    private final String refId;

    private RestSynchronizeRefRequest(Builder builder) {
        super(builder);
        this.action = builder.action;
        this.context = builder.context.build();
        this.refId = builder.refId;
        this.body = new JSONObject();
        this.body.put((Object)"refId", (Object)this.refId);
        this.body.put((Object)"action", (Object)this.action);
        if (!this.context.isEmpty()) {
            this.body.put((Object)"context", (Object)JSONObject.fromObject(this.context));
        }
    }

    @Override
    @Nonnull
    public JSONObject getBody() {
        return this.body;
    }

    public static class Builder
    extends AbstractRestRequest.AbstractBuilder<Builder, RestSynchronizeRefRequest> {
        private final ImmutableMap.Builder<String, Object> context;
        private final String refId;
        private RestRefSyncAction action;

        public Builder(String refId) {
            this.refId = Builder.checkNotBlank((String)refId, (String)"refId");
            this.action = RestRefSyncAction.MERGE;
            this.context = ImmutableMap.builder();
        }

        public Builder(@Nonnull RestSynchronizeRefRequest request) {
            super(request);
            this.action = request.action;
            this.context = ImmutableMap.builder();
            this.context.putAll(request.context);
            this.refId = request.refId;
        }

        @Nonnull
        public Builder action(@Nonnull RestRefSyncAction value) {
            this.action = (RestRefSyncAction)((Object)Preconditions.checkNotNull((Object)((Object)value), (Object)"action"));
            return this.self();
        }

        @Override
        @Nonnull
        public RestSynchronizeRefRequest build() {
            return new RestSynchronizeRefRequest(this);
        }

        @Nonnull
        public Builder context(@Nonnull String key, @Nonnull Object value) {
            this.context.put((Object)Builder.checkNotBlank((String)key, (String)"key"), Preconditions.checkNotNull((Object)value, (Object)"value"));
            return this.self();
        }

        @Nonnull
        public Builder context(@Nonnull Map<String, Object> value) {
            this.context.putAll(value);
            return this.self();
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

