/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.test.rules;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryRule
implements TestRule {
    private static final Logger logger = LoggerFactory.getLogger(RetryRule.class);
    private static final String OUTPUT_FILE = "target/flakey.log";
    private static final int RETRY_FAILURE_COUNT = Integer.getInteger("test.retry.count", 1);
    private static final int RETRY_FAILURE_LIMIT = Integer.getInteger("test.retry.failureLimit", 20);
    private static int testFailures = 0;
    private static PrintWriter logWriter;
    private final int count;

    public RetryRule() {
        this(RETRY_FAILURE_COUNT);
    }

    public RetryRule(int count) {
        this.count = count;
    }

    public Statement apply(final Statement base, final Description description) {
        if (!this.shouldRetry()) {
            logger.info("%s: RetryRule is disabled.", (Object)description);
            return base;
        }
        return new Statement(){

            public void evaluate() throws Throwable {
                Throwable t = null;
                for (int i = 0; i < RetryRule.this.count; ++i) {
                    try {
                        base.evaluate();
                        if (i > 0) {
                            RetryRule.log(description.getClassName() + ":" + description.getMethodName(), t);
                        }
                        return;
                    }
                    catch (Throwable throwable) {
                        t = throwable;
                        logger.error(String.format("%s: Test run %d failed", description, i + 1), t);
                        continue;
                    }
                }
                testFailures++;
                if (!RetryRule.this.shouldRetry()) {
                    logger.error("Maximum number of retries reached!");
                }
                throw t;
            }
        };
    }

    private static void log(String method, Throwable t) throws IOException {
        PrintWriter writer = RetryRule.getOrCreateLogWriter();
        writer.println("TEST: " + method);
        t.printStackTrace(writer);
        writer.println();
        writer.flush();
    }

    private static PrintWriter getOrCreateLogWriter() throws IOException {
        if (logWriter == null) {
            logWriter = new PrintWriter(Files.newWriter((File)new File(OUTPUT_FILE), (Charset)Charsets.UTF_8));
        }
        return logWriter;
    }

    private boolean shouldRetry() {
        return this.count > 1 && testFailures < RETRY_FAILURE_LIMIT;
    }
}

