/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.test.runners;

import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.Parameterized;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.TestClass;

public abstract class ParameterisedRunnerBase
extends Runner {
    protected final TestClass testClass;
    protected final ParentRunner<?> target;

    public ParameterisedRunnerBase(Class<?> klass) throws Throwable {
        this.testClass = new TestClass(klass);
        this.target = this.isParameterised() ? new Parameterized(klass) : new BlockJUnit4ClassRunner(klass);
    }

    boolean isParameterised() {
        return !this.testClass.getAnnotatedMethods(Parameterized.Parameters.class).isEmpty();
    }

    public Description getDescription() {
        return this.target.getDescription();
    }

    public void run(RunNotifier notifier) {
        this.target.run(notifier);
    }

    protected TestClass getTestClass() {
        return this.testClass;
    }
}

