/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.rest.data;

import com.atlassian.stash.avatar.AvatarRequest;
import com.atlassian.stash.content.Changeset;
import com.atlassian.stash.rest.annotations.JsonSurrogate;
import com.atlassian.stash.rest.data.RestMinimalChangeset;
import com.atlassian.stash.rest.data.RestPage;
import com.atlassian.stash.rest.data.RestPerson;
import com.atlassian.stash.rest.docs.RestDocletHelper;
import com.atlassian.stash.rest.enrich.AvatarEnricher;
import com.atlassian.stash.rest.util.RestUtils;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.sun.jersey.spi.container.ContainerRequest;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@Deprecated
@JsonSerialize
@JsonSurrogate(value=Changeset.class)
public class RestChangeset
extends RestMinimalChangeset {
    public static final Function<Changeset, RestChangeset> REST_TRANSFORM = new Function<Changeset, RestChangeset>(){

        public RestChangeset apply(Changeset changeset) {
            return new RestChangeset(changeset);
        }
    };
    public static final RestChangeset EXAMPLE = new RestChangeset("abcdef0123abcdef4567abcdef8987abcdef6543", "abcdef0123a", RestPerson.EXAMPLE, new Date(), "WIP on feature 1", Lists.newArrayList((Object[])new RestMinimalChangeset[]{RestMinimalChangeset.EXAMPLE}), null, null);
    public static final RestChangeset EXAMPLE_ALT = new RestChangeset("def0123abcdef4567abcdef8987abcdef6543abc", "def0123abcd", RestPerson.EXAMPLE, new Date(), "More work on feature 1", Lists.newArrayList((Object[])new RestMinimalChangeset[]{RestMinimalChangeset.EXAMPLE}), null, null);
    public static final RestPage<RestChangeset> PAGE_EXAMPLE = RestDocletHelper.decorate(RestDocletHelper.pageOf(EXAMPLE_ALT), ImmutableMap.of((Object)"authorCount", (Object)1, (Object)"totalCount", (Object)1));

    public RestChangeset(Changeset changeset) {
        this(changeset.getId(), changeset.getDisplayId(), (RestPerson)RestPerson.REST_TRANSFORM.apply((Object)changeset.getAuthor()), changeset.getAuthorTimestamp(), changeset.getMessage(), (Collection<RestMinimalChangeset>)ImmutableList.copyOf(RestChangeset.transform(changeset.getParents(), RestMinimalChangeset.REST_TRANSFORM)), (Map<String, Set<String>>)changeset.getAttributes(), (Map<String, Object>)changeset.getProperties());
    }

    private RestChangeset(String id, String displayId, RestPerson author, Date authorTimestamp, String message, Collection<RestMinimalChangeset> parents, Map<String, Set<String>> attributes, Map<String, Object> properties) {
        super(id, displayId);
        this.putIfNotNull("author", author);
        this.put("authorTimestamp", authorTimestamp);
        this.put("message", message);
        this.put("parents", parents);
        this.putIfNotEmpty("attributes", attributes);
        this.putIfNotEmpty("properties", properties);
    }

    public static Function<Changeset, RestChangeset> createChangesetTransformer(@Nonnull ContainerRequest request, final @Nonnull AvatarEnricher avatarEnricher) {
        final AvatarRequest avatarRequest = RestUtils.makeAvatarRequest(request);
        if (avatarRequest == null) {
            return REST_TRANSFORM;
        }
        return new Function<Changeset, RestChangeset>(){

            public RestChangeset apply(Changeset changeset) {
                RestChangeset restChangeset = new RestChangeset(changeset);
                avatarEnricher.enrich(restChangeset, avatarRequest);
                return restChangeset;
            }
        };
    }
}

