/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.rest.data;

import com.atlassian.stash.content.AttributeMap;
import com.atlassian.stash.content.Diff;
import com.atlassian.stash.property.PropertyMap;
import com.atlassian.stash.rest.annotations.JsonSurrogate;
import com.atlassian.stash.rest.data.RestComment;
import com.atlassian.stash.rest.data.RestDiffHunk;
import com.atlassian.stash.rest.data.RestMapEntity;
import com.atlassian.stash.rest.data.RestPath;
import com.atlassian.stash.rest.data.RestPropertySupport;
import com.atlassian.stash.rest.docs.RestDocletHelper;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Map;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
@JsonSurrogate(value=Diff.class)
public class RestDiff
extends RestPropertySupport {
    public static final Function<Diff, RestDiff> REST_TRANSFORM = new Function<Diff, RestDiff>(){

        public RestDiff apply(Diff input) {
            return new RestDiff(input);
        }
    };
    public static final RestDiff EXAMPLE = new RestDiff(RestPath.EXAMPLE, RestPath.EXAMPLE, false, Lists.newArrayList((Object[])new RestDiffHunk[]{RestDiffHunk.HUNKY_EXAMPLE}), null, false, null, null);
    public static final RestDiff EXAMPLE_COMMENT = new RestDiff(RestPath.EXAMPLE, RestPath.EXAMPLE, false, Lists.newArrayList((Object[])new RestDiffHunk[]{RestDiffHunk.HUNKY_EXAMPLE_COMMENTED}), Lists.newArrayList((Object[])new RestComment[]{RestComment.RESPONSE_EXAMPLE_NO_REPLY}), false, null, null);
    public static final RestMapEntity PAGE_EXAMPLE = RestDocletHelper.wrap(Collections.singletonList(EXAMPLE), "diffs");
    public static final RestMapEntity PAGE_WITH_COMMENTS_EXAMPLE = RestDocletHelper.wrap(Collections.singletonList(EXAMPLE_COMMENT), "diffs");

    public RestDiff() {
    }

    public RestDiff(Diff diff) {
        this(RestPath.fromPath(diff.getSource()), RestPath.fromPath(diff.getDestination()), diff.isBinary(), diff.isBinary() ? null : RestDiff.transform(diff.getHunks(), RestDiffHunk.REST_TRANSFORM), null, diff.isTruncated(), diff.getAttributes(), diff.getProperties());
    }

    private RestDiff(RestPath source, RestPath destination, boolean isBinary, Iterable<RestDiffHunk> hunks, Iterable<RestComment> lineComments, boolean isTruncated, AttributeMap attributes, PropertyMap properties) {
        this.put("source", source);
        this.put("destination", destination);
        if (isBinary) {
            this.put("binary", true);
        } else {
            this.put("hunks", hunks);
            this.putIfNotEmpty("lineComments", lineComments);
            this.putIfNotNull("truncated", isTruncated);
            this.putIfNotEmpty("attributes", (Map<?, ?>)attributes);
            this.putProperties((Map<String, Object>)properties);
        }
    }
}

