/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.rest.data;

import com.atlassian.stash.exception.ServiceException;
import com.atlassian.stash.rest.data.RestErrorMessage;
import com.atlassian.stash.rest.data.RestMapEntity;
import com.atlassian.stash.rest.util.StatefulJsonWriter;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
public class RestErrors
extends RestMapEntity {
    public static final String ERRORS = "errors";
    public static final RestErrors EXAMPLE = new RestErrors("A detailed error message.");
    public static final RestErrors VALIDATION_EXAMPLE = new RestErrors((Collection<RestErrorMessage>)ImmutableList.of((Object)new RestErrorMessage("field_a", "A detailed validation error message for field_a."), (Object)new RestErrorMessage("A detailed error message.")));

    public RestErrors() {
        this.put(ERRORS, new ArrayList());
    }

    public RestErrors(Collection<RestErrorMessage> errors) {
        this.put(ERRORS, new ArrayList<RestErrorMessage>(errors));
    }

    public RestErrors(String error) {
        this(new RestErrorMessage(error));
    }

    public RestErrors(String context, String error) {
        this(new RestErrorMessage(context, error, null));
    }

    public RestErrors(ServiceException e) {
        this(new RestErrorMessage(e));
    }

    public RestErrors(RestErrorMessage message) {
        this(Collections.singletonList(message));
    }

    public void addError(String error) {
        this.addError(new RestErrorMessage(error));
    }

    public void addError(RestErrorMessage error) {
        this.getErrors().add(error);
    }

    public void addRestMessageErrors(Iterable<RestErrorMessage> errors) {
        Iterables.addAll(this.getErrors(), errors);
    }

    public void addErrors(Iterable<String> errors) {
        Iterables.addAll(this.getErrors(), (Iterable)Iterables.transform(errors, (Function)new Function<String, RestErrorMessage>(){

            public RestErrorMessage apply(String input) {
                return new RestErrorMessage(input);
            }
        }));
    }

    public boolean endScopeAndTryWriteTo(StatefulJsonWriter writer) throws IOException {
        StatefulJsonWriter.WritingState writingState = writer.endToDocument().getWritingState();
        if (writingState.getContext() == StatefulJsonWriter.WritingContext.ROOT && writingState.getEntryCount() == 0) {
            writer.beginObject();
            this.writeErrors(writer);
            writer.endObject();
            return true;
        }
        if (writingState.getContext() == StatefulJsonWriter.WritingContext.OBJECT) {
            this.writeErrors(writer);
            writer.endObject();
            return true;
        }
        return false;
    }

    private void writeErrors(StatefulJsonWriter writer) throws IOException {
        writer.name(ERRORS);
        writer.beginArray();
        for (RestErrorMessage message : this.getErrors()) {
            writer.value(message);
        }
        writer.endArray();
    }

    public List<RestErrorMessage> getErrors() {
        return (List)this.get(ERRORS);
    }
}

