/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.rest.data;

import com.atlassian.stash.rest.annotations.JsonSurrogate;
import com.atlassian.stash.rest.data.AvatarAware;
import com.atlassian.stash.rest.data.RestDetailedUser;
import com.atlassian.stash.rest.data.RestMapEntity;
import com.atlassian.stash.rest.data.RestStashUser;
import com.atlassian.stash.user.DetailedUser;
import com.atlassian.stash.user.Person;
import com.atlassian.stash.user.StashUser;
import com.google.common.base.Function;
import java.util.Map;
import javax.annotation.Nonnull;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
@JsonSurrogate(value=Person.class)
public class RestPerson
extends RestMapEntity
implements AvatarAware,
Person {
    public static final Function<Person, RestPerson> REST_TRANSFORM = new Function<Person, RestPerson>(){

        public RestPerson apply(Person person) {
            if (person == null) {
                return null;
            }
            if (person instanceof DetailedUser) {
                return new RestDetailedUser((DetailedUser)person);
            }
            if (person instanceof StashUser) {
                return new RestStashUser((StashUser)person);
            }
            return new RestPerson(person);
        }
    };
    public static final String EMAIL_ADDRESS = "emailAddress";
    public static final String NAME = "name";
    public static final RestPerson EXAMPLE = new RestPerson("charlie", "charlie@example.com");
    public static final RestPerson EXAMPLE_NAME_ONLY = new RestPerson("charlie", null);

    public RestPerson(Person author) {
        this(author.getName(), author.getEmailAddress());
    }

    protected RestPerson(String name, String emailAddress) {
        this.putIfNotNull(NAME, name);
        this.putIfNotNull(EMAIL_ADDRESS, emailAddress);
    }

    public RestPerson(Map<String, Object> map) {
        super(map);
    }

    public String getEmailAddress() {
        return this.getStringProperty(EMAIL_ADDRESS);
    }

    @Nonnull
    public String getName() {
        return this.getStringProperty(NAME);
    }

    @Override
    public void setAvatarUrl(String avatarUrl) {
        this.put("avatarUrl", avatarUrl);
    }
}

