/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.rest.data;

import com.atlassian.stash.pull.PullRequestParticipant;
import com.atlassian.stash.pull.PullRequestRole;
import com.atlassian.stash.rest.annotations.JsonSurrogate;
import com.atlassian.stash.rest.data.RestMapEntity;
import com.atlassian.stash.rest.data.RestPage;
import com.atlassian.stash.rest.data.RestPerson;
import com.atlassian.stash.rest.data.RestStashUser;
import com.atlassian.stash.rest.docs.ExampleDetailedUser;
import com.atlassian.stash.rest.docs.RestDocletHelper;
import com.atlassian.stash.user.StashUser;
import com.google.common.base.Function;
import java.util.Map;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
@JsonSurrogate(value=PullRequestParticipant.class)
public class RestPullRequestParticipant
extends RestMapEntity {
    public static final Function<PullRequestParticipant, RestPullRequestParticipant> REST_TRANSFORM = new Function<PullRequestParticipant, RestPullRequestParticipant>(){

        public RestPullRequestParticipant apply(PullRequestParticipant participant) {
            return new RestPullRequestParticipant(participant);
        }
    };
    public static final String USER = "user";
    public static final String ROLE = "role";
    public static final String APPROVED = "approved";
    public static final RestPullRequestParticipant REQUEST_EXAMPLE_ADD_REVIEWER = new RestPullRequestParticipant(RestStashUser.EXAMPLE_NAME_ONLY, PullRequestRole.REVIEWER, null);
    public static final RestPullRequestParticipant EXAMPLE_RESPONSE_REVIEWER_APPROVED = new RestPullRequestParticipant(RestStashUser.RESPONSE_EXAMPLE, PullRequestRole.REVIEWER, (Boolean)true);
    public static final RestPullRequestParticipant EXAMPLE_RESPONSE_REVIEWER_UNAPPROVED = new RestPullRequestParticipant(RestStashUser.RESPONSE_EXAMPLE, PullRequestRole.REVIEWER, (Boolean)false);
    public static final RestPullRequestParticipant REQUEST_EXAMPLE_USER_ONLY = new RestPullRequestParticipant(RestStashUser.EXAMPLE_NAME_ONLY, null, null);
    public static final RestPullRequestParticipant REQUEST_EXAMPLE_REVIEWER = new RestPullRequestParticipant(RestStashUser.EXAMPLE_NAME_ONLY, PullRequestRole.REVIEWER, null);
    public static final RestPage<RestPullRequestParticipant> PAGE = RestDocletHelper.pageOf(EXAMPLE_RESPONSE_REVIEWER_APPROVED);

    public RestPullRequestParticipant() {
    }

    public RestPullRequestParticipant(PullRequestParticipant participant) {
        this(new RestStashUser(participant.getUser()), participant.getRole(), (Boolean)participant.isApproved());
    }

    public RestPullRequestParticipant(Map<String, Object> values) {
        super(values);
    }

    private RestPullRequestParticipant(RestPerson user, PullRequestRole role, Boolean approved) {
        this.putIfNotNull(USER, user);
        this.putIfNotNull(ROLE, role);
        this.putIfNotNull(APPROVED, approved);
    }

    public PullRequestRole getRole() {
        return this.getEnumProperty(ROLE, PullRequestRole.class);
    }

    public RestStashUser getUser() {
        return RestStashUser.valueOf(this.get(USER));
    }

    public static RestPullRequestParticipant valueOf(Object value) {
        if (value instanceof RestPullRequestParticipant) {
            return (RestPullRequestParticipant)value;
        }
        if (value instanceof Map) {
            return new RestPullRequestParticipant((Map)value);
        }
        return null;
    }

    public static RestPullRequestParticipant newExample(String name, PullRequestRole role, Boolean approved) {
        ExampleDetailedUser exampleUser = ExampleDetailedUser.newExample(name);
        return new RestPullRequestParticipant(new RestStashUser((StashUser)exampleUser), role, approved);
    }
}

