/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.util;

import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumberUtils {
    private static final List<SizeUnit> SIZE_UNITS = ImmutableList.copyOf((Object[])SizeUnit.values());
    private static final Logger log = LoggerFactory.getLogger(NumberUtils.class);

    private NumberUtils() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is a utility class and should not be instantiated");
    }

    @Nullable
    public static Integer parse(@Nullable String s, @Nullable Integer defaultValue, @Nullable String message) {
        block3: {
            if (StringUtils.isNotEmpty((String)s)) {
                try {
                    return Integer.parseInt(s);
                }
                catch (NumberFormatException e) {
                    if (message == null) break block3;
                    log.error(message);
                }
            }
        }
        return defaultValue;
    }

    @Nullable
    public static Integer parse(@Nullable String s, @Nullable String message) {
        return NumberUtils.parse(s, null, message);
    }

    @Nonnull
    public static String formatSize(double size) {
        Iterator<SizeUnit> it = SIZE_UNITS.iterator();
        SizeUnit unit = it.next();
        while (it.hasNext() && size > 1024.0) {
            size /= 1024.0;
            unit = it.next();
        }
        return unit.format(size);
    }

    @Nullable
    public static Long toLong(@Nullable String s, @Nullable Long defaultValue) {
        return NumberUtils.toLong(s, defaultValue, null);
    }

    @Nullable
    public static Long toLong(@Nullable String s, @Nullable Long defaultValue, @Nullable String message) {
        block3: {
            if (StringUtils.isNotEmpty((String)s)) {
                try {
                    return Long.parseLong(s);
                }
                catch (NumberFormatException e) {
                    if (message == null) break block3;
                    log.error(message);
                }
            }
        }
        return defaultValue;
    }

    private static enum SizeUnit {
        B{

            @Override
            public String format(double size) {
                return String.format("%1$.0f B", size);
            }
        }
        ,
        KB,
        MB,
        GB;


        public String format(double size) {
            return String.format("%1$.2f %2$s", size, this.name());
        }
    }
}

