package com.atlassian.user.impl;

import com.atlassian.user.Entity;
import java.util.Date;

public abstract class DefaultEntity implements Entity
{
    protected String name;
    protected transient Date created;

    protected DefaultEntity()
    {
        created = new Date();
    }

    public DefaultEntity(String name)
    {
        this.name = name;
        created = new Date();
    }

    public String getName()
    {
        return name;
    }

    public void setName(String name)
    {
        this.name = name;
    }

    public Date getCreated()
    {
        return created;
    }

    public void setCreated(Date created)
    {
        this.created = created;
    }

    protected DefaultEntity(String name, long id, Date created)
    {
        this.name = name;
        this.created = created;
    }

    public boolean equals(Object o)
    {
        if (this == o) return true;
        if (!(o instanceof DefaultEntity)) return false;

        final DefaultEntity defaultEntity = (DefaultEntity) o;

        if (name != null ? !name.equals(defaultEntity.name) : defaultEntity.name != null) return false;

        return true;
    }

    public int hashCode()
    {
        return (name != null ? name.hashCode() : 0);
    }
}
